/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v1;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.util.List;
import java.util.Map;
import org.apache.seata.core.compressor.Compressor;
import org.apache.seata.core.compressor.CompressorFactory;
import org.apache.seata.core.exception.DecodeException;
import org.apache.seata.core.protocol.HeartbeatMessage;
import org.apache.seata.core.protocol.ProtocolConstants;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolDecoder;
import org.apache.seata.core.rpc.netty.v1.HeadMapSerializer;
import org.apache.seata.core.rpc.netty.v1.ProtocolRpcMessageV1;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDecoderV1
extends LengthFieldBasedFrameDecoder
implements ProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolDecoderV1.class);
    private final List<SerializerType> supportDeSerializerTypes = SerializerServiceLoader.getSupportedSerializers();

    public ProtocolDecoderV1() {
        super(0x800000, 3, 4, -7, 0);
        if (this.supportDeSerializerTypes.isEmpty()) {
            throw new IllegalArgumentException("No serializer found");
        }
    }

    @Override
    public RpcMessage decodeFrame(ByteBuf frame) {
        byte b0 = frame.readByte();
        byte b1 = frame.readByte();
        if (ProtocolConstants.MAGIC_CODE_BYTES[0] != b0 || ProtocolConstants.MAGIC_CODE_BYTES[1] != b1) {
            throw new IllegalArgumentException("Unknown magic code: " + b0 + ", " + b1);
        }
        byte version = frame.readByte();
        int fullLength = frame.readInt();
        short headLength = frame.readShort();
        byte messageType = frame.readByte();
        byte codecType = frame.readByte();
        byte compressorType = frame.readByte();
        int requestId = frame.readInt();
        ProtocolRpcMessageV1 rpcMessage = new ProtocolRpcMessageV1();
        rpcMessage.setCodec(codecType);
        rpcMessage.setId(requestId);
        rpcMessage.setCompressor(compressorType);
        rpcMessage.setMessageType(messageType);
        int headMapLength = headLength - 16;
        if (headMapLength > 0) {
            Map<String, String> map = HeadMapSerializer.getInstance().decode(frame, headMapLength);
            rpcMessage.getHeadMap().putAll(map);
        }
        if (messageType == 3) {
            rpcMessage.setBody(HeartbeatMessage.PING);
        } else if (messageType == 4) {
            rpcMessage.setBody(HeartbeatMessage.PONG);
        } else {
            int bodyLength = fullLength - headLength;
            if (bodyLength > 0) {
                byte[] bs = new byte[bodyLength];
                frame.readBytes(bs);
                Compressor compressor = CompressorFactory.getCompressor(compressorType);
                bs = compressor.decompress(bs);
                SerializerType protocolType = SerializerType.getByCode(rpcMessage.getCodec());
                if (this.supportDeSerializerTypes.contains((Object)protocolType)) {
                    Serializer serializer = SerializerServiceLoader.load(protocolType, (byte)1);
                    rpcMessage.setBody(serializer.deserialize(bs));
                } else {
                    throw new IllegalArgumentException("SerializerType not match");
                }
            }
        }
        return rpcMessage.protocolMsg2RpcMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        Object decoded;
        block5: {
            RpcMessage rpcMessage;
            decoded = super.decode(ctx, in);
            if (!(decoded instanceof ByteBuf)) break block5;
            ByteBuf frame = (ByteBuf)decoded;
            try {
                rpcMessage = this.decodeFrame(frame);
            }
            catch (Throwable throwable) {
                try {
                    frame.release();
                    throw throwable;
                }
                catch (Exception exx) {
                    LOGGER.error("Decode frame error, cause: {}", (Object)exx.getMessage());
                    throw new DecodeException(exx);
                }
            }
            frame.release();
            return rpcMessage;
        }
        return decoded;
    }
}

