/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateMachineAdapter
implements StateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineAdapter.class);

    @Override
    public void onShutdown() {
        LOG.info("onShutdown.");
    }

    @Override
    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        this.error("onSnapshotSave");
        this.runClosure(done, "onSnapshotSave");
    }

    @Override
    public boolean onSnapshotLoad(SnapshotReader reader) {
        this.error("onSnapshotLoad", "while a snapshot is saved in " + reader.getPath());
        return false;
    }

    @Override
    public void onLeaderStart(long term) {
        LOG.info("onLeaderStart: term={}.", (Object)term);
    }

    @Override
    public void onLeaderStop(Status status) {
        LOG.info("onLeaderStop: status={}.", (Object)status);
    }

    @Override
    public void onError(RaftException e) {
        LOG.error("Encountered an error={} on StateMachine {}, it's highly recommended to implement this method as raft stops working since some error occurs, you should figure out the cause and repair or remove this node.", new Object[]{e.getStatus(), this.getClassName(), e});
    }

    @Override
    public void onConfigurationCommitted(Configuration conf) {
        LOG.info("onConfigurationCommitted: {}.", (Object)conf);
    }

    @Override
    public void onStopFollowing(LeaderChangeContext ctx) {
        LOG.info("onStopFollowing: {}.", (Object)ctx);
    }

    @Override
    public void onStartFollowing(LeaderChangeContext ctx) {
        LOG.info("onStartFollowing: {}.", (Object)ctx);
    }

    private void runClosure(Closure done, String methodName) {
        done.run(new Status(-1, "%s doesn't implement %s", this.getClassName(), methodName));
    }

    private String getClassName() {
        return this.getClass().getName();
    }

    private void error(String methodName) {
        this.error(methodName, "");
    }

    private void error(String methodName, String msg) {
        LOG.error("{} doesn't implement {} {}.", new Object[]{this.getClassName(), methodName, msg});
    }
}

