/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.apache.fory.annotation.Internal;
import org.apache.fory.collection.ObjectArray;

@Internal
public class CollectionSnapshot<E>
extends AbstractCollection<E> {
    private static final int CLEAR_ARRAY_SIZE_THRESHOLD = 2048;
    ObjectArray<E> array = new ObjectArray(16);
    Collection<E> collection;
    int size;
    int iterIndex;
    private final CollectionIterator iterator = new CollectionIterator();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        this.iterIndex = 0;
        return this.iterator;
    }

    public void setCollection(Collection<E> collection) {
        ObjectArray<E> array = this.array;
        int size = 0;
        for (E element : collection) {
            array.add(element);
            ++size;
        }
        this.size = size;
    }

    @Override
    public void clear() {
        if (this.size > 2048) {
            this.array = new ObjectArray(16);
        } else {
            this.array.clear();
        }
        this.iterIndex = 0;
        this.size = 0;
    }

    class CollectionIterator
    implements Iterator<E> {
        CollectionIterator() {
        }

        @Override
        public boolean hasNext() {
            return CollectionSnapshot.this.iterIndex < CollectionSnapshot.this.size;
        }

        @Override
        public E next() {
            return CollectionSnapshot.this.array.get(CollectionSnapshot.this.iterIndex++);
        }
    }
}

