/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.logging;

import org.apache.fory.logging.ForyLogger;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.Slf4jLogger;
import org.apache.fory.util.GraalvmSupport;

public class LoggerFactory {
    private static volatile boolean useSlf4jLogger;
    private static volatile int logLevel;

    public static void disableLogging() {
        logLevel = -1;
    }

    public static void enableLogging() {
        logLevel = 2;
    }

    public static boolean isLoggingDisabled() {
        return logLevel < 0;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void useSlf4jLogging(boolean useSlf4jLogging) {
        useSlf4jLogger = useSlf4jLogging;
    }

    public static Logger getLogger(Class<?> clazz) {
        if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE || !useSlf4jLogger) {
            return new ForyLogger(clazz);
        }
        return LoggerFactory.createSlf4jLogger(clazz);
    }

    private static Logger createSlf4jLogger(Class<?> clazz) {
        return new Slf4jLogger(clazz);
    }

    static {
        logLevel = 2;
    }
}

