/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatementExceptionVisitor;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatementTSStatusVisitor;
import org.apache.iotdb.db.storageengine.load.converter.LoadTreeStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileDataTypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileDataTypeConverter.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    public static final LoadConvertedInsertTabletStatementTSStatusVisitor STATEMENT_STATUS_VISITOR = new LoadConvertedInsertTabletStatementTSStatusVisitor();
    public static final LoadConvertedInsertTabletStatementExceptionVisitor STATEMENT_EXCEPTION_VISITOR = new LoadConvertedInsertTabletStatementExceptionVisitor();
    private final boolean isGeneratedByPipe;
    private final LoadTreeStatementDataTypeConvertExecutionVisitor treeStatementDataTypeConvertExecutionVisitor = new LoadTreeStatementDataTypeConvertExecutionVisitor(this::executeForTreeModel);

    public LoadTsFileDataTypeConverter(boolean isGeneratedByPipe) {
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    public Optional<TSStatus> convertForTreeModel(LoadTsFileStatement loadTsFileTreeStatement) {
        try {
            return loadTsFileTreeStatement.accept(this.treeStatementDataTypeConvertExecutionVisitor, null);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to convert data types for tree model statement {}.", (Object)loadTsFileTreeStatement, (Object)e);
            return Optional.of(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
        }
    }

    private TSStatus executeForTreeModel(Statement statement) {
        return Coordinator.getInstance().executeForTreeModel((Statement)(this.isGeneratedByPipe ? new PipeEnrichedStatement((Statement)statement) : statement), (long)LoadTsFileDataTypeConverter.SESSION_MANAGER.requestQueryId(), (SessionInfo)LoadTsFileDataTypeConverter.SESSION_MANAGER.getSessionInfo((IClientSession)LoadTsFileDataTypeConverter.SESSION_MANAGER.getCurrSession()), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), (boolean)false).status;
    }

    public boolean isSuccessful(TSStatus status) {
        return status != null && (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || status.getCode() == TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode());
    }
}

