/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointUrlListDataType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class NetworkGroupDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11944");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11950");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11958");
    private final String serverUri;
    private final EndpointUrlListDataType[] networkPaths;

    public NetworkGroupDataType(String serverUri, EndpointUrlListDataType[] networkPaths) {
        this.serverUri = serverUri;
        this.networkPaths = networkPaths;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public EndpointUrlListDataType[] getNetworkPaths() {
        return this.networkPaths;
    }

    protected NetworkGroupDataType(NetworkGroupDataTypeBuilder<?, ?> b) {
        super(b);
        this.serverUri = ((NetworkGroupDataTypeBuilder)b).serverUri;
        this.networkPaths = ((NetworkGroupDataTypeBuilder)b).networkPaths;
    }

    public static NetworkGroupDataTypeBuilder<?, ?> builder() {
        return new NetworkGroupDataTypeBuilderImpl();
    }

    public NetworkGroupDataTypeBuilder<?, ?> toBuilder() {
        return new NetworkGroupDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkGroupDataType)) {
            return false;
        }
        NetworkGroupDataType other = (NetworkGroupDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUri = this.getServerUri();
        String other$serverUri = other.getServerUri();
        if (this$serverUri == null ? other$serverUri != null : !this$serverUri.equals(other$serverUri)) {
            return false;
        }
        return Arrays.deepEquals(this.getNetworkPaths(), other.getNetworkPaths());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetworkGroupDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUri = this.getServerUri();
        result = result * 59 + ($serverUri == null ? 43 : $serverUri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNetworkPaths());
        return result;
    }

    @Override
    public String toString() {
        return "NetworkGroupDataType(serverUri=" + this.getServerUri() + ", networkPaths=" + Arrays.deepToString(this.getNetworkPaths()) + ")";
    }

    private static final class NetworkGroupDataTypeBuilderImpl
    extends NetworkGroupDataTypeBuilder<NetworkGroupDataType, NetworkGroupDataTypeBuilderImpl> {
        private NetworkGroupDataTypeBuilderImpl() {
        }

        @Override
        protected NetworkGroupDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public NetworkGroupDataType build() {
            return new NetworkGroupDataType(this);
        }
    }

    public static abstract class NetworkGroupDataTypeBuilder<C extends NetworkGroupDataType, B extends NetworkGroupDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String serverUri;
        private EndpointUrlListDataType[] networkPaths;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NetworkGroupDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(NetworkGroupDataType instance, NetworkGroupDataTypeBuilder<?, ?> b) {
            b.serverUri(instance.serverUri);
            b.networkPaths(instance.networkPaths);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverUri(String serverUri) {
            this.serverUri = serverUri;
            return (B)this.self();
        }

        public B networkPaths(EndpointUrlListDataType[] networkPaths) {
            this.networkPaths = networkPaths;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NetworkGroupDataType.NetworkGroupDataTypeBuilder(super=" + super.toString() + ", serverUri=" + this.serverUri + ", networkPaths=" + Arrays.deepToString(this.networkPaths) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<NetworkGroupDataType> {
        @Override
        public Class<NetworkGroupDataType> getType() {
            return NetworkGroupDataType.class;
        }

        @Override
        public NetworkGroupDataType decode(SerializationContext context, UaDecoder decoder) {
            String serverUri = decoder.readString("ServerUri");
            EndpointUrlListDataType[] networkPaths = (EndpointUrlListDataType[])decoder.readStructArray("NetworkPaths", EndpointUrlListDataType.TYPE_ID);
            return new NetworkGroupDataType(serverUri, networkPaths);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NetworkGroupDataType value) {
            encoder.writeString("ServerUri", value.getServerUri());
            encoder.writeStructArray("NetworkPaths", (Object[])value.getNetworkPaths(), EndpointUrlListDataType.TYPE_ID);
        }
    }
}

