/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client.api;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.io.CloseAsync;
import org.apache.ratis.io.FilePositionCount;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.RaftClientReply;

public interface DataStreamOutput
extends CloseAsync<DataStreamReply> {
    default public CompletableFuture<DataStreamReply> writeAsync(ByteBuffer src, WriteOption ... options) {
        return this.writeAsync(src, Arrays.asList(options));
    }

    public CompletableFuture<DataStreamReply> writeAsync(ByteBuffer var1, Iterable<WriteOption> var2);

    default public CompletableFuture<DataStreamReply> writeAsync(File src, WriteOption ... options) {
        return this.writeAsync(src, 0L, src.length(), options);
    }

    default public CompletableFuture<DataStreamReply> writeAsync(File src, long position, long count, WriteOption ... options) {
        return this.writeAsync(FilePositionCount.valueOf((File)src, (long)position, (long)count), options);
    }

    public CompletableFuture<DataStreamReply> writeAsync(FilePositionCount var1, WriteOption ... var2);

    public CompletableFuture<RaftClientReply> getRaftClientReplyFuture();

    public WritableByteChannel getWritableByteChannel();
}

