/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.overview;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeRemainingEventAndTimeOperator;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.source.dataregion.IoTDBDataRegionSource;
import org.apache.iotdb.db.pipe.source.schemaregion.IoTDBSchemaRegionSource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeSinglePipeMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeSinglePipeMetrics.class);
    private volatile AbstractMetricService metricService;
    public final Map<String, PipeDataNodeRemainingEventAndTimeOperator> remainingEventAndTimeOperatorMap = new ConcurrentHashMap<String, PipeDataNodeRemainingEventAndTimeOperator>();
    private static Histogram PIPE_DATANODE_INSERTNODE_TRANSFER_TIME_HISTOGRAM = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private static Histogram PIPE_DATANODE_TSFILE_TRANSFER_TIME_HISTOGRAM = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        PIPE_DATANODE_INSERTNODE_TRANSFER_TIME_HISTOGRAM = metricService.getOrCreateHistogram(Metric.PIPE_DATANODE_EVENT_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "insert_node"});
        PIPE_DATANODE_TSFILE_TRANSFER_TIME_HISTOGRAM = metricService.getOrCreateHistogram(Metric.PIPE_DATANODE_EVENT_TRANSFER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "tsfile"});
        ImmutableSet.copyOf(this.remainingEventAndTimeOperatorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String pipeID) {
        this.createAutoGauge(pipeID);
    }

    private void createAutoGauge(String pipeID) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        this.metricService.createAutoGauge(Metric.PIPE_DATANODE_REMAINING_EVENT_COUNT.toString(), MetricLevel.IMPORTANT, (Object)operator, PipeDataNodeRemainingEventAndTimeOperator::getRemainingNonHeartbeatEvents, new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_DATANODE_REMAINING_TIME.toString(), MetricLevel.IMPORTANT, (Object)operator, PipeDataNodeRemainingEventAndTimeOperator::getRemainingTime, new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_FLOATING_MEMORY_USAGE.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeAgent.task(), a -> a.getFloatingMemoryUsageInByte(operator.getPipeName()), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_LINKED_TSFILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.tsfile(), a -> a.getLinkedTsFileCount(operator.getPipeName()), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.createAutoGauge(Metric.PIPE_LINKED_TSFILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.tsfile(), a -> a.getTotalLinkedTsFileSize(operator.getPipeName()), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        operator.setInsertNodeTransferTimer(this.metricService.getOrCreateTimer(Metric.PIPE_INSERT_NODE_EVENT_TRANSFER_TIME.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operator.getPipeName()}));
        operator.setTsFileTransferTimer(this.metricService.getOrCreateTimer(Metric.PIPE_TSFILE_EVENT_TRANSFER_TIME.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operator.getPipeName()}));
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.remainingEventAndTimeOperatorMap.keySet()).forEach(this::deregister);
        if (!this.remainingEventAndTimeOperatorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe remaining event and time metrics, RemainingEventAndTimeOperator map not empty");
        }
        metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_DATANODE_EVENT_TRANSFER.toString(), new String[]{Tag.NAME.toString(), "insert_node"});
        metricService.remove(MetricType.HISTOGRAM, Metric.PIPE_DATANODE_EVENT_TRANSFER.toString(), new String[]{Tag.NAME.toString(), "tsfile"});
    }

    private void removeMetrics(String pipeID) {
        this.removeAutoGauge(pipeID);
    }

    private void removeAutoGauge(String pipeID) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_DATANODE_REMAINING_EVENT_COUNT.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_DATANODE_REMAINING_TIME.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_FLOATING_MEMORY_USAGE.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_LINKED_TSFILE_COUNT.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_LINKED_TSFILE_SIZE.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName(), Tag.CREATION_TIME.toString(), String.valueOf(operator.getCreationTime())});
        this.metricService.remove(MetricType.TIMER, Metric.PIPE_INSERT_NODE_EVENT_TRANSFER_TIME.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName()});
        this.metricService.remove(MetricType.TIMER, Metric.PIPE_TSFILE_EVENT_TRANSFER_TIME.toString(), new String[]{Tag.NAME.toString(), operator.getPipeName()});
        this.remainingEventAndTimeOperatorMap.remove(pipeID);
    }

    public void register(IoTDBDataRegionSource extractor) {
        String pipeID = extractor.getPipeName() + "_" + extractor.getCreationTime();
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeID, k -> new PipeDataNodeRemainingEventAndTimeOperator(extractor.getPipeName(), extractor.getCreationTime()));
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(pipeID);
        }
    }

    public void register(IoTDBSchemaRegionSource extractor) {
        String pipeID = extractor.getPipeName() + "_" + extractor.getCreationTime();
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeID, k -> new PipeDataNodeRemainingEventAndTimeOperator(extractor.getPipeName(), extractor.getCreationTime())).register(extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(pipeID);
        }
    }

    public void increaseInsertNodeEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseInsertNodeEventCount();
    }

    public void decreaseInsertNodeEventCount(String pipeName, long creationTime, long transferTime) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime));
        operator.decreaseInsertNodeEventCount();
        if (transferTime > 0L) {
            operator.getInsertNodeTransferTimer().update(transferTime, TimeUnit.NANOSECONDS);
            PIPE_DATANODE_INSERTNODE_TRANSFER_TIME_HISTOGRAM.update(transferTime);
        }
    }

    public void increaseRawTabletEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseRawTabletEventCount();
    }

    public void decreaseRawTabletEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).decreaseRawTabletEventCount();
    }

    public void increaseTsFileEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseTsFileEventCount();
    }

    public void decreaseTsFileEventCount(String pipeName, long creationTime, long transferTime) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime));
        operator.decreaseTsFileEventCount();
        if (transferTime > 0L) {
            operator.getTsFileTransferTimer().update(transferTime, TimeUnit.NANOSECONDS);
            PIPE_DATANODE_TSFILE_TRANSFER_TIME_HISTOGRAM.update(transferTime);
        }
    }

    public void increaseHeartbeatEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).increaseHeartbeatEventCount();
    }

    public void decreaseHeartbeatEventCount(String pipeName, long creationTime) {
        this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime)).decreaseHeartbeatEventCount();
    }

    public void thawRate(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingEventAndTimeOperatorMap.get(pipeID).thawRate(true);
    }

    public void freezeRate(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            return;
        }
        this.remainingEventAndTimeOperatorMap.get(pipeID).freezeRate(true);
    }

    public void deregister(String pipeID) {
        if (!this.remainingEventAndTimeOperatorMap.containsKey(pipeID)) {
            LOGGER.warn("Failed to deregister pipe remaining event and time metrics, RemainingEventAndTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(pipeID);
        }
    }

    public void markRegionCommit(String pipeID, boolean isDataRegion) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        if (Objects.isNull((Object)operator)) {
            LOGGER.warn("Failed to mark pipe region commit, RemainingEventAndTimeOperator({}) does not exist", (Object)pipeID);
            return;
        }
        if (isDataRegion) {
            operator.markDataRegionCommit();
        } else {
            operator.markSchemaRegionCommit();
        }
    }

    public void markTsFileCollectInvocationCount(String pipeID, long collectInvocationCount) {
        if (Objects.isNull(this.metricService)) {
            return;
        }
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.get(pipeID);
        if (Objects.isNull((Object)operator)) {
            return;
        }
        operator.markTsFileCollectInvocationCount(collectInvocationCount);
    }

    public Pair<Long, Double> getRemainingEventAndTime(String pipeName, long creationTime) {
        PipeDataNodeRemainingEventAndTimeOperator operator = this.remainingEventAndTimeOperatorMap.computeIfAbsent(pipeName + "_" + creationTime, k -> new PipeDataNodeRemainingEventAndTimeOperator(pipeName, creationTime));
        return new Pair((Object)operator.getRemainingNonHeartbeatEvents(), (Object)operator.getRemainingTime());
    }

    public static PipeDataNodeSinglePipeMetrics getInstance() {
        return PipeDataNodeSinglePipeMetricsHolder.INSTANCE;
    }

    private PipeDataNodeSinglePipeMetrics() {
        PipeEventCommitManager.getInstance().setCommitRateMarker(this::markRegionCommit);
    }

    private static class PipeDataNodeSinglePipeMetricsHolder {
        private static final PipeDataNodeSinglePipeMetrics INSTANCE = new PipeDataNodeSinglePipeMetrics();

        private PipeDataNodeSinglePipeMetricsHolder() {
        }
    }
}

