/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.tools.utils.TsFileSequenceScan;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileValidationScan
extends TsFileSequenceScan {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileValidationScan.class);
    private static final String STR_FIND_BAD_FILE = "-- Find the bad file ";
    private static final String STR_OVERLAP_LATTER_FILE = ", overlap with latter files.";
    private static final String STR_OVERLAP_BETWEEN_FILE = " overlap between files, with previous file ";
    private static final String STR_TIMESERIES = "-------- Timeseries ";
    private static final String FILE_NON_EXIST = "";
    private static final IDeviceID EMPTY_DEVICE_ID = new PlainDeviceID("");
    protected boolean printDetails;
    protected boolean ignoreFileOverlap = false;
    protected long currentChunkEndTime;
    protected long currentPageEndTime;
    protected long lastPageEndTime;
    protected TsFileResource resource;
    protected Map<IDeviceID, Boolean> hasCheckedDeviceOverlap;
    protected Map<Pair<IDeviceID, String>, SeriesOverlapPrintInfo> hasSeriesPrintedDetails;
    protected Map<Pair<IDeviceID, String>, Long> lashChunkEndTime;
    protected Map<Pair<IDeviceID, String>, FileLastTimeInfo> timeseriesLastTimeMap = new HashMap<Pair<IDeviceID, String>, FileLastTimeInfo>();
    protected Map<IDeviceID, FileLastTimeInfo> deviceEndTime = new HashMap<IDeviceID, FileLastTimeInfo>();
    protected Map<String, Boolean> isBadFileMap = new HashMap<String, Boolean>();
    protected int badFileNum;
    protected List<String> previousBadFileMsgs = new ArrayList<String>();

    @Override
    protected boolean onFileOpen(File file) throws IOException {
        super.onFileOpen(file);
        this.hasCheckedDeviceOverlap = new HashMap<IDeviceID, Boolean>();
        this.currDeviceID = EMPTY_DEVICE_ID;
        this.hasSeriesPrintedDetails = new HashMap<Pair<IDeviceID, String>, SeriesOverlapPrintInfo>();
        this.lashChunkEndTime = new HashMap<Pair<IDeviceID, String>, Long>();
        this.resource = new TsFileResource(file);
        if (!new File(file.getAbsolutePath() + ".resource").exists()) {
            LOGGER.warn("{} does not exist ,skip it.", (Object)(file.getAbsolutePath() + ".resource"));
            return false;
        }
        this.resource.deserialize();
        this.isBadFileMap.put(file.getName(), false);
        return true;
    }

    @Override
    protected void onFileEnd() {
        for (Map.Entry<Pair<IDeviceID, String>, Long> entry : this.lashChunkEndTime.entrySet()) {
            FileLastTimeInfo fileNameLastTime = this.timeseriesLastTimeMap.computeIfAbsent((Pair<IDeviceID, String>)this.currTimeseriesID, id -> new FileLastTimeInfo());
            if (fileNameLastTime.endTimeInLastFile > entry.getValue()) continue;
            fileNameLastTime.endTimeInLastFile = entry.getValue();
            fileNameLastTime.lastFileName = this.file.getName();
        }
        if (this.ignoreFileOverlap) {
            this.reset(false);
        }
    }

    @Override
    protected void onChunkGroup() throws IOException {
        Optional<Long> endTime;
        FileLastTimeInfo fileNameLastTimePair = this.deviceEndTime.computeIfAbsent(this.currDeviceID, k -> new FileLastTimeInfo());
        if (!this.currDeviceID.equals(EMPTY_DEVICE_ID) && (endTime = this.resource.getEndTime(this.currDeviceID)).isPresent() && endTime.get() > fileNameLastTimePair.lastTime) {
            fileNameLastTimePair.lastFileName = this.file.getName();
            fileNameLastTimePair.endTimeInLastFile = endTime.get();
        }
        super.onChunkGroup();
        fileNameLastTimePair = this.deviceEndTime.computeIfAbsent(this.currDeviceID, k -> new FileLastTimeInfo());
        if (!Boolean.TRUE.equals(this.hasCheckedDeviceOverlap.getOrDefault(this.currDeviceID, false)) && this.resource.getStartTime(this.currDeviceID).isPresent() && this.resource.getStartTime(this.currDeviceID).get() <= fileNameLastTimePair.endTimeInLastFile) {
            this.recordDeviceOverlap(fileNameLastTimePair.lastFileName);
        }
        this.hasCheckedDeviceOverlap.put(this.currDeviceID, true);
    }

    private void recordDeviceOverlap(String badFileName) {
        if (!Boolean.TRUE.equals(this.isBadFileMap.get(badFileName))) {
            if (this.printDetails) {
                this.previousBadFileMsgs.add(STR_FIND_BAD_FILE + this.file.getParentFile().getAbsolutePath() + File.separator + this.deviceEndTime.get(this.currDeviceID).lastFileName + STR_OVERLAP_LATTER_FILE);
            } else {
                this.previousBadFileMsgs.add(this.file.getParentFile().getAbsolutePath() + File.separator + this.deviceEndTime.get(this.currDeviceID).lastFileName);
            }
            this.isBadFileMap.put(badFileName, true);
            ++this.badFileNum;
        }
        if (!Boolean.TRUE.equals(this.isBadFileMap.get(this.file.getName()))) {
            if (this.printDetails) {
                this.printBoth(STR_FIND_BAD_FILE + this.file.getAbsolutePath());
            } else {
                this.printBoth(this.file.getAbsolutePath());
            }
            this.isBadFileMap.put(this.file.getName(), true);
            ++this.badFileNum;
        }
        if (this.printDetails) {
            this.printBoth("---- Device " + this.currDeviceID + STR_OVERLAP_BETWEEN_FILE + this.deviceEndTime.get(this.currDeviceID).lastFileName);
        }
    }

    @Override
    protected void onTimePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) throws IOException {
        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
        long[] timeBatch = timePageReader.getNextTimeBatch();
        FileLastTimeInfo fileNameLastTimePair = this.timeseriesLastTimeMap.computeIfAbsent((Pair<IDeviceID, String>)this.currTimeseriesID, id -> new FileLastTimeInfo());
        for (long timestamp : timeBatch) {
            this.onTimeStamp(timestamp, fileNameLastTimePair);
        }
        this.lastPageEndTime = Math.max(this.lastPageEndTime, this.currentPageEndTime);
    }

    protected void markInFileOverlap() {
        if (!Boolean.TRUE.equals(this.isBadFileMap.get(this.file.getName()))) {
            if (this.printDetails) {
                this.printBoth(STR_FIND_BAD_FILE + this.file.getAbsolutePath());
            } else {
                this.printBoth(this.file.getAbsolutePath());
            }
            this.isBadFileMap.put(this.file.getName(), true);
            ++this.badFileNum;
        }
    }

    private void markBetweenFileOverlap(String overLapFile) {
        if (!Boolean.TRUE.equals(this.isBadFileMap.getOrDefault(overLapFile, false))) {
            if (this.printDetails) {
                this.previousBadFileMsgs.add(STR_FIND_BAD_FILE + this.file.getParentFile().getAbsolutePath() + File.separator + overLapFile + STR_OVERLAP_LATTER_FILE);
            } else {
                this.previousBadFileMsgs.add(this.file.getParentFile().getAbsolutePath() + File.separator + overLapFile);
            }
            this.isBadFileMap.put(overLapFile, true);
            ++this.badFileNum;
        }
    }

    protected void printOverlapDetails(long timestamp, FileLastTimeInfo seriesLastTime) {
        SeriesOverlapPrintInfo seriesOverlapPrintInfo = this.hasSeriesPrintedDetails.computeIfAbsent((Pair<IDeviceID, String>)this.currTimeseriesID, k -> new SeriesOverlapPrintInfo());
        if (timestamp <= seriesLastTime.endTimeInLastFile) {
            if (!seriesOverlapPrintInfo.betweenFileOverlapPrinted) {
                this.printBoth(STR_TIMESERIES + this.currTimeseriesID + STR_OVERLAP_BETWEEN_FILE + seriesLastTime.lastFileName);
                seriesOverlapPrintInfo.betweenFileOverlapPrinted = true;
            }
        } else if (timestamp <= this.lashChunkEndTime.getOrDefault(this.currTimeseriesID, Long.MIN_VALUE)) {
            if (!seriesOverlapPrintInfo.chunkOverlapPrinted) {
                this.printBoth(STR_TIMESERIES + this.currTimeseriesID + " overlap between chunks");
                seriesOverlapPrintInfo.chunkOverlapPrinted = true;
            }
        } else if (timestamp <= this.lastPageEndTime) {
            if (!seriesOverlapPrintInfo.crossPageOverlapPrinted) {
                this.printBoth(STR_TIMESERIES + this.currTimeseriesID + " overlap between pages");
                seriesOverlapPrintInfo.crossPageOverlapPrinted = true;
            }
        } else if (!seriesOverlapPrintInfo.inPagePOverlapPrinted) {
            this.printBoth(STR_TIMESERIES + this.currTimeseriesID + " overlap within one page");
            seriesOverlapPrintInfo.inPagePOverlapPrinted = true;
        }
    }

    @Override
    protected void onValuePage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) {
    }

    @Override
    protected void onNonAlignedPage(PageHeader pageHeader, ByteBuffer pageData, ChunkHeader chunkHeader) throws IOException {
        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
        PageReader pageReader = new PageReader(pageData, chunkHeader.getDataType(), valueDecoder, defaultTimeDecoder);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        FileLastTimeInfo fileNameLastTimePair = this.timeseriesLastTimeMap.computeIfAbsent((Pair<IDeviceID, String>)this.currTimeseriesID, id -> new FileLastTimeInfo());
        while (batchData.hasCurrent()) {
            long timestamp = batchData.currentTime();
            this.onTimeStamp(timestamp, fileNameLastTimePair);
            batchData.next();
        }
        this.lastPageEndTime = Math.max(this.lastPageEndTime, this.currentPageEndTime);
    }

    private void onTimeStamp(long timestamp, FileLastTimeInfo fileNameLastTimePair) {
        if (timestamp <= fileNameLastTimePair.lastTime) {
            this.markInFileOverlap();
            if (timestamp <= fileNameLastTimePair.endTimeInLastFile) {
                this.markBetweenFileOverlap(fileNameLastTimePair.lastFileName);
            }
            if (this.printDetails) {
                this.printOverlapDetails(timestamp, fileNameLastTimePair);
            }
        } else {
            fileNameLastTimePair.lastTime = timestamp;
            this.currentPageEndTime = timestamp;
            this.currentChunkEndTime = timestamp;
        }
    }

    @Override
    protected void onChunk(TsFileSequenceScan.PageVisitor pageVisitor) throws IOException {
        this.currentChunkEndTime = Long.MIN_VALUE;
        this.lastPageEndTime = Long.MIN_VALUE;
        super.onChunk(pageVisitor);
        this.lashChunkEndTime.put((Pair<IDeviceID, String>)this.currTimeseriesID, Math.max(this.lashChunkEndTime.getOrDefault(this.currTimeseriesID, Long.MIN_VALUE), this.currentChunkEndTime));
    }

    public List<String> getPreviousBadFileMsgs() {
        return this.previousBadFileMsgs;
    }

    @Override
    protected void onException(Throwable t) {
        LOGGER.error("Meet errors in reading file {} , skip it.", (Object)this.file.getAbsolutePath(), (Object)t);
        if (!Boolean.TRUE.equals(this.isBadFileMap.get(this.file.getName()))) {
            if (this.printDetails) {
                this.printBoth("-- Meet errors in reading file " + this.file.getAbsolutePath() + ", tsfile may be corrupted.");
            } else {
                this.printBoth(this.file.getAbsolutePath());
            }
            this.isBadFileMap.put(this.file.getName(), true);
            ++this.badFileNum;
        }
    }

    public int getBadFileNum() {
        return this.badFileNum;
    }

    public void setBadFileNum(int badFileNum) {
        this.badFileNum = badFileNum;
    }

    public void reset(boolean resetBadFileNum) {
        if (resetBadFileNum) {
            this.badFileNum = 0;
        }
        this.timeseriesLastTimeMap.clear();
        this.deviceEndTime.clear();
        this.isBadFileMap.clear();
    }

    public void setPrintDetails(boolean printDetails) {
        this.printDetails = printDetails;
    }

    public void setIgnoreFileOverlap(boolean ignoreFileOverlap) {
        this.ignoreFileOverlap = ignoreFileOverlap;
    }

    protected static class FileLastTimeInfo {
        private String lastFileName = "";
        private long lastTime = Long.MIN_VALUE;
        private long endTimeInLastFile = Long.MIN_VALUE;
    }

    protected static class SeriesOverlapPrintInfo {
        private boolean betweenFileOverlapPrinted;
        private boolean chunkOverlapPrinted;
        private boolean crossPageOverlapPrinted;
        private boolean inPagePOverlapPrinted;

        protected SeriesOverlapPrintInfo() {
        }
    }
}

