/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class MatchAllScorer
extends Scorer {
    private int nextDoc = -1;
    private IndexReader reader;
    private String field;
    private BitSet docFilter;

    MatchAllScorer(IndexReader reader, String field, PerQueryCache cache) throws IOException {
        super(Similarity.getDefault());
        this.reader = reader;
        this.field = field;
        this.calculateDocFilter(cache);
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        while (this.nextDoc() != Integer.MAX_VALUE) {
            collector.collect(this.docID());
        }
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.nextDoc == Integer.MAX_VALUE) {
            return this.nextDoc;
        }
        this.nextDoc = this.docFilter.nextSetBit(this.nextDoc + 1);
        if (this.nextDoc < 0) {
            this.nextDoc = Integer.MAX_VALUE;
        }
        return this.nextDoc;
    }

    @Override
    public int docID() {
        return this.nextDoc;
    }

    @Override
    public float score() throws IOException {
        return 1.0f;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.nextDoc == Integer.MAX_VALUE) {
            return this.nextDoc;
        }
        if (target == Integer.MAX_VALUE) {
            this.nextDoc = Integer.MAX_VALUE;
            return this.nextDoc;
        }
        this.nextDoc = target - 1;
        return this.nextDoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDocFilter(PerQueryCache cache) throws IOException {
        HashMap<String, BitSet> readerCache = (HashMap<String, BitSet>)cache.get(MatchAllScorer.class, this.reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, BitSet>();
            cache.put(MatchAllScorer.class, this.reader, readerCache);
        }
        this.docFilter = (BitSet)readerCache.get(this.field);
        if (this.docFilter != null) {
            return;
        }
        this.docFilter = new BitSet(this.reader.maxDoc());
        String namedValue = FieldNames.createNamedValue(this.field, "");
        try (TermEnum terms = this.reader.terms(new Term(FieldNames.PROPERTIES, namedValue));
             TermDocs docs = this.reader.termDocs();){
            while (terms.term() != null && terms.term().field() == FieldNames.PROPERTIES && terms.term().text().startsWith(namedValue)) {
                docs.seek(terms);
                while (docs.next()) {
                    this.docFilter.set(docs.doc());
                }
                terms.next();
            }
        }
        readerCache.put(this.field, this.docFilter);
    }
}

