/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.tika.detect.zip.StreamingDetectContext;
import org.apache.tika.detect.zip.ZipContainerDetector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;

public class IPADetector
implements ZipContainerDetector {
    static final MediaType IPA = MediaType.application("x-itunes-ipa");
    private static HashSet<Pattern> ipaEntryPatterns = new HashSet<Pattern>(){
        private static final long serialVersionUID = 6545295886322115362L;
        {
            this.add(Pattern.compile("^Payload/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/$"));
            this.add(Pattern.compile("^Payload/.*\\.app/_CodeSignature/CodeResources$"));
            this.add(Pattern.compile("^Payload/.*\\.app/Info\\.plist$"));
            this.add(Pattern.compile("^Payload/.*\\.app/PkgInfo$"));
        }
    };

    @Override
    public MediaType detect(ZipFile zip, TikaInputStream tis) throws IOException {
        TmpPatterns tmpPatterns = new TmpPatterns();
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            String name = entry.getName();
            tmpPatterns.patterns.removeIf(pattern -> pattern.matcher(name).matches());
            if (!tmpPatterns.patterns.isEmpty()) continue;
            return MediaType.application("x-itunes-ipa");
        }
        return null;
    }

    @Override
    public MediaType streamingDetectUpdate(ZipArchiveEntry zae, InputStream zis, StreamingDetectContext detectContext) {
        String name = zae.getName();
        TmpPatterns tmp = detectContext.get(TmpPatterns.class);
        if (tmp == null) {
            tmp = new TmpPatterns();
            detectContext.set(TmpPatterns.class, tmp);
        }
        tmp.patterns.removeIf(pattern -> pattern.matcher(name).matches());
        if (tmp.patterns.isEmpty()) {
            return IPA;
        }
        return null;
    }

    @Override
    public MediaType streamingDetectFinal(StreamingDetectContext detectContext) {
        TmpPatterns tmp = detectContext.get(TmpPatterns.class);
        if (tmp == null) {
            return null;
        }
        if (tmp.patterns.isEmpty()) {
            return IPA;
        }
        detectContext.remove(TmpPatterns.class);
        return null;
    }

    static /* synthetic */ HashSet access$100() {
        return ipaEntryPatterns;
    }

    private static class TmpPatterns {
        Set<Pattern> patterns = (Set)IPADetector.access$100().clone();

        private TmpPatterns() {
        }
    }
}

