/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.export.api.BlobExportMechanism;
import org.apache.james.blob.export.api.FileExtension;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageContentNotFoundException;
import org.apache.james.vault.DeletedMessageVault;
import org.apache.james.vault.DeletedMessageZipper;
import org.apache.james.vault.search.Query;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportService.class);
    private static final Predicate<Throwable> CONTENT_NOT_FOUND_PREDICATE = throwable -> throwable instanceof DeletedMessageContentNotFoundException;
    private final BlobExportMechanism blobExport;
    private final BlobStore blobStore;
    private final DeletedMessageZipper zipper;
    private final DeletedMessageVault vault;

    @Inject
    @VisibleForTesting
    ExportService(BlobExportMechanism blobExport, BlobStore blobStore, DeletedMessageZipper zipper, DeletedMessageVault vault) {
        this.blobExport = blobExport;
        this.blobStore = blobStore;
        this.zipper = zipper;
        this.vault = vault;
    }

    void export(Username username, Query exportQuery, MailAddress exportToAddress, Runnable messageToExportCallback) throws IOException {
        Flux matchedMessages = Flux.from((Publisher)this.vault.search(username, exportQuery)).doOnNext(any -> messageToExportCallback.run());
        BlobId blobId = this.zipToBlob(username, (Flux<DeletedMessage>)matchedMessages);
        this.blobExport.blobId(blobId).with(exportToAddress).explanation(this.exportMessage(username)).filePrefix(String.format("deleted-message-of-%s_", username.asString())).fileExtension(FileExtension.ZIP).export();
    }

    private BlobId zipToBlob(Username username, Flux<DeletedMessage> messages) throws IOException {
        try (FileBackedOutputStream fileOutputStream = new FileBackedOutputStream(FileUtils.ONE_MB_BI.intValue());){
            this.zipper.zip(this.contentLoader(username), messages.toStream(), (OutputStream)fileOutputStream);
            ByteSource byteSource = fileOutputStream.asByteSource();
            BlobId blobId = (BlobId)Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), byteSource.openStream(), BlobStore.StoragePolicy.LOW_COST)).block();
            return blobId;
        }
    }

    private DeletedMessageZipper.DeletedMessageContentLoader contentLoader(Username username) {
        return message -> Mono.from((Publisher)this.vault.loadMimeMessage(username, message.getMessageId())).onErrorResume(CONTENT_NOT_FOUND_PREDICATE, throwable -> {
            LOGGER.info("Error happened when loading mime message associated with id {} of user {} in the vault", new Object[]{message.getMessageId().serialize(), username.asString(), throwable});
            return Mono.empty();
        }).blockOptional();
    }

    private String exportMessage(Username username) {
        return String.format("Some deleted messages from user %s has been shared to you", username.asString());
    }
}

