/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.support.ValueType;

public class InternalDateRange
extends InternalRange<Bucket, InternalDateRange> {
    public static final Factory FACTORY = new Factory();

    InternalDateRange(String name, List<Bucket> ranges, DocValueFormat formatter, boolean keyed, Map<String, Object> metadata) {
        super(name, ranges, formatter, keyed, metadata);
    }

    public InternalDateRange(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "date_range";
    }

    @Override
    public InternalRange.Factory<Bucket, InternalDateRange> getFactory() {
        return FACTORY;
    }

    public static class Factory
    extends InternalRange.Factory<Bucket, InternalDateRange> {
        @Override
        public ValueType getValueType() {
            return ValueType.DATE;
        }

        @Override
        public InternalDateRange create(String name, List<Bucket> ranges, DocValueFormat formatter, boolean keyed, Map<String, Object> metadata) {
            return new InternalDateRange(name, ranges, formatter, keyed, metadata);
        }

        @Override
        public InternalDateRange create(List<Bucket> ranges, InternalDateRange prototype) {
            return new InternalDateRange(prototype.name, ranges, prototype.format, prototype.keyed, (Map<String, Object>)prototype.metadata);
        }

        @Override
        public Bucket createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            return new Bucket(key, from, to, docCount, aggregations, keyed, formatter);
        }

        @Override
        public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
            return new Bucket(prototype.getKey(), (double)prototype.internalGetFrom(), (double)prototype.internalGetTo(), prototype.getDocCount(), aggregations, prototype.getKeyed(), prototype.getFormat());
        }
    }

    public static class Bucket
    extends InternalRange.Bucket {
        public Bucket(String key, double from, double to, long docCount, List<InternalAggregation> aggregations, boolean keyed, DocValueFormat formatter) {
            super(key, from, to, docCount, InternalAggregations.from(aggregations), keyed, formatter);
        }

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat formatter) {
            super(key, from, to, docCount, aggregations, keyed, formatter);
        }

        @Override
        public Object getFrom() {
            return Double.isInfinite(this.from) ? null : Instant.ofEpochMilli(((Number)this.from).longValue()).atZone(ZoneOffset.UTC);
        }

        @Override
        public Object getTo() {
            return Double.isInfinite(this.to) ? null : Instant.ofEpochMilli(((Number)this.to).longValue()).atZone(ZoneOffset.UTC);
        }

        private Double internalGetFrom() {
            return this.from;
        }

        private Double internalGetTo() {
            return this.to;
        }

        protected InternalRange.Factory<Bucket, ?> getFactory() {
            return FACTORY;
        }

        boolean keyed() {
            return this.keyed;
        }

        DocValueFormat format() {
            return this.format;
        }
    }
}

