/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public abstract class LongExtraField
implements ZipExtraField {
    private Optional<Long> value;

    LongExtraField() {
        this(Optional.empty());
    }

    LongExtraField(long value) {
        this(Optional.of(value));
    }

    LongExtraField(Optional<Long> value) {
        this.value = value;
    }

    public ZipShort getLocalFileDataLength() {
        return new ZipShort(8);
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        long value = this.value.orElseThrow(() -> new RuntimeException("Value must by initialized"));
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(value).array();
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
        if (length != 8) {
            throw new ZipException("Unexpected data length for ExtraField. Expected 8 but got " + length + ".");
        }
        this.value = Optional.of(ByteBuffer.wrap(buffer, offset, 8).order(ByteOrder.LITTLE_ENDIAN).getLong());
    }

    public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) throws ZipException {
        this.parseFromLocalFileData(buffer, offset, length);
    }

    public Optional<Long> getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof LongExtraField) {
            LongExtraField that = (LongExtraField)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.getHeaderId(), that.getHeaderId());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value, this.getHeaderId());
    }
}

