/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.jmap.draft.methods.SetMessagesCreationProcessor;
import org.apache.james.jmap.draft.methods.SetMessagesProcessor;
import org.apache.james.jmap.draft.model.SetError;
import org.apache.james.jmap.draft.model.SetMessagesRequest;
import org.apache.james.jmap.draft.model.SetMessagesResponse;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SetMessagesDestructionProcessor
implements SetMessagesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetMessagesCreationProcessor.class);
    private final MessageIdManager messageIdManager;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    SetMessagesDestructionProcessor(MessageIdManager messageIdManager, MetricFactory metricFactory) {
        this.messageIdManager = messageIdManager;
        this.metricFactory = metricFactory;
    }

    @Override
    public Mono<SetMessagesResponse> processReactive(SetMessagesRequest request, MailboxSession mailboxSession) {
        if (request.getDestroy().isEmpty()) {
            return Mono.just((Object)SetMessagesResponse.builder().build());
        }
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-SetMessageDestructionProcessor", this.delete(request.getDestroy(), mailboxSession)));
    }

    private Mono<SetMessagesResponse> delete(List<MessageId> toBeDestroyed, MailboxSession mailboxSession) {
        if (toBeDestroyed.isEmpty()) {
            return Mono.just((Object)SetMessagesResponse.builder().build());
        }
        return Mono.from((Publisher)this.messageIdManager.delete(toBeDestroyed, mailboxSession)).map(deleteResult -> SetMessagesResponse.builder().destroyed((List<MessageId>)ImmutableList.copyOf((Collection)deleteResult.getDestroyed())).notDestroyed((Map)deleteResult.getNotFound().stream().map(messageId -> Pair.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.NOT_FOUND).description("The message " + messageId.serialize() + " can't be found").build())).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))).build()).onErrorResume(e -> {
            LOGGER.error("An error occurred when deleting a message", e);
            return Mono.just((Object)SetMessagesResponse.builder().notDestroyed((Map)toBeDestroyed.stream().map(messageId -> Pair.of((Object)messageId, (Object)SetError.builder().type(SetError.Type.ERROR).description("An error occurred while deleting messages " + messageId.serialize()).build())).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))).build());
        });
    }
}

