/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RefCountMessage {
    private static final AtomicIntegerFieldUpdater<RefCountMessage> DURABLE_REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "durableRefCount");
    private static final AtomicIntegerFieldUpdater<RefCountMessage> REF_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "refCount");
    private static final AtomicIntegerFieldUpdater<RefCountMessage> REF_USAGE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountMessage.class, "usageCount");
    private volatile HashMap userContext;
    private volatile int durableRefCount = 0;
    private volatile int refCount = 0;
    private volatile int usageCount = 0;
    private volatile boolean fired = false;
    private volatile RefCountMessage parentRef;

    public int getRefCount() {
        return REF_COUNT_UPDATER.get(this);
    }

    public int getUsage() {
        return REF_USAGE_UPDATER.get(this);
    }

    public int getDurableCount() {
        return DURABLE_REF_COUNT_UPDATER.get(this);
    }

    public RefCountMessage getParentRef() {
        return this.parentRef;
    }

    private void onUp() {
    }

    private void onDown() {
        if (this.getRefCount() <= 0 && this.getUsage() <= 0 && this.getDurableCount() <= 0 && !this.fired) {
            this.debugRefs();
            this.fired = true;
            this.releaseComplete();
        }
    }

    public final void debugRefs() {
    }

    public String debugString() {
        return "refCount=" + this.getRefCount() + ", durableRefCount=" + this.getDurableCount() + ", usageCount=" + this.getUsage() + ", parentRef=" + this.parentRef;
    }

    public void setParentRef(RefCountMessage origin) {
        this.parentRef = origin.getParentRef() != null ? origin.getParentRef() : origin;
    }

    protected void releaseComplete() {
    }

    public int usageUp() {
        if (this.parentRef != null) {
            return this.parentRef.usageUp();
        }
        int count = REF_USAGE_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public int usageDown() {
        if (this.parentRef != null) {
            return this.parentRef.usageDown();
        }
        int count = REF_USAGE_UPDATER.decrementAndGet(this);
        this.onDown();
        return count;
    }

    public int durableUp() {
        if (this.parentRef != null) {
            return this.parentRef.durableUp();
        }
        int count = DURABLE_REF_COUNT_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public int durableDown() {
        if (this.parentRef != null) {
            return this.parentRef.durableDown();
        }
        int count = DURABLE_REF_COUNT_UPDATER.decrementAndGet(this);
        this.onDown();
        return count;
    }

    public int refDown() {
        if (this.parentRef != null) {
            return this.parentRef.refDown();
        }
        int count = REF_COUNT_UPDATER.decrementAndGet(this);
        this.onDown();
        return count;
    }

    public int refUp() {
        if (this.parentRef != null) {
            return this.parentRef.refUp();
        }
        int count = REF_COUNT_UPDATER.incrementAndGet(this);
        this.onUp();
        return count;
    }

    public Object getUserContext(Object key) {
        if (this.userContext == null) {
            return null;
        }
        return this.userContext.get(key);
    }

    public void setUserContext(Object key, Object value) {
        if (this.userContext == null) {
            this.userContext = new HashMap();
        }
        this.userContext.put(key, value);
    }
}

