/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi;

import org.apache.jena.shared.JenaException;

public class OntJenaException
extends JenaException {
    public OntJenaException() {
    }

    public OntJenaException(String message) {
        super(message);
    }

    public OntJenaException(Throwable cause) {
        super(cause);
    }

    public OntJenaException(String message, Throwable cause) {
        super(message, cause);
    }

    public static <T> T notNull(T obj) {
        return OntJenaException.notNull(obj, null);
    }

    public static <T> T notNull(T obj, String message) {
        if (obj == null) {
            throw message == null ? new IllegalArgument() : new IllegalArgument(message);
        }
        return obj;
    }

    public static <X> X TODO(String message) {
        throw new RuntimeException(message);
    }

    public static <X> X checkNotNull(X object) {
        if (object == null) {
            throw new IllegalStateException();
        }
        return object;
    }

    public static <X> X checkNotNull(X object, String message) {
        OntJenaException.checkTrue(object != null, message);
        return object;
    }

    public static void checkFalse(Boolean mustBeFalse, String message) {
        if (mustBeFalse.booleanValue()) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkTrue(Boolean mustBeTrue, String message) {
        if (!mustBeTrue.booleanValue()) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkSupported(boolean feature) {
        OntJenaException.checkSupported(feature, null);
    }

    public static void checkSupported(boolean feature, String message) {
        if (!feature) {
            throw new Unsupported(message);
        }
    }

    public static class IllegalArgument
    extends OntJenaException {
        public IllegalArgument() {
        }

        public IllegalArgument(String message) {
            super(message);
        }

        public IllegalArgument(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Unsupported
    extends OntJenaException {
        public Unsupported(String message) {
            super(message);
        }
    }

    public static class IllegalState
    extends OntJenaException {
        public IllegalState() {
        }

        public IllegalState(String message) {
            super(message);
        }

        public IllegalState(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Recursion
    extends OntJenaException {
        public Recursion(String message) {
            super(message);
        }
    }

    public static class IllegalCall
    extends OntJenaException {
        public IllegalCall() {
        }

        public IllegalCall(String message) {
            super(message);
        }
    }

    public static class Creation
    extends OntJenaException {
        public Creation(String message, Throwable cause) {
            super(message, cause);
        }

        public Creation(String message) {
            super(message);
        }
    }

    public static class Conversion
    extends OntJenaException {
        public Conversion(String message, Throwable cause) {
            super(message, cause);
        }

        public Conversion(String message) {
            super(message);
        }
    }
}

