/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdfs.DatasetGraphRDFS;
import org.apache.jena.rdfs.GraphRDFS;
import org.apache.jena.rdfs.InfStreamRDFS;
import org.apache.jena.rdfs.SetupRDFS;
import org.apache.jena.rdfs.engine.MapperX;
import org.apache.jena.rdfs.setup.BaseSetupRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.NodeUtils;

public class RDFSFactory {
    public static Graph graphRDFS(Graph data, Graph vocab) {
        return RDFSFactory.graphRDFS(data, new SetupRDFS(vocab));
    }

    public static Graph graphRDFS(Graph data) {
        return RDFSFactory.graphRDFS(data, new SetupRDFS(data));
    }

    public static Graph graphRDFS(Graph data, SetupRDFS setup) {
        return new GraphRDFS(data, setup);
    }

    public static DatasetGraph datasetRDFS(DatasetGraph data, SetupRDFS setup) {
        return new DatasetGraphRDFS(data, setup);
    }

    public static DatasetGraph datasetRDFS(DatasetGraph data, Graph vocab) {
        SetupRDFS setup = RDFSFactory.setupRDFS(vocab);
        return RDFSFactory.datasetRDFS(data, setup);
    }

    public static Dataset datasetRDFS(Dataset data, Graph vocab) {
        SetupRDFS setup = RDFSFactory.setupRDFS(vocab);
        return DatasetFactory.wrap(RDFSFactory.datasetRDFS(data.asDatasetGraph(), setup));
    }

    public static SetupRDFS setupRDFS(Graph vocab) {
        return new SetupRDFS(vocab);
    }

    public static <X> ConfigRDFS<X> setupRDFS(Graph vocab, final MapperX<X, ?> mapper) {
        return new BaseSetupRDFS<X>(vocab){

            @Override
            protected X fromNode(Node node) {
                return mapper.fromNode(node);
            }
        };
    }

    public static StreamRDF streamRDFS(StreamRDF data, Graph vocab) {
        SetupRDFS setup = new SetupRDFS(vocab);
        return RDFSFactory.streamRDFS(data, setup);
    }

    public static StreamRDF streamRDFS(StreamRDF data, SetupRDFS setup) {
        return new InfStreamRDFS(data, setup);
    }

    public static StreamRDF removeGeneralizedRDF(StreamRDF data) {
        return NodeUtils.removeGeneralizedRDF(data);
    }
}

