/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.lan;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Locale;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.cat.CodeListUID;
import org.apache.sis.xml.bind.gco.CharSequenceAdapter;
import org.apache.sis.xml.bind.gco.GO_CharacterString;
import org.apache.sis.xml.bind.lan.LanguageCode;

@XmlType(name="Country_PropertyType")
public final class Country
extends GO_CharacterString {
    private CodeListUID identifier;
    private boolean isLegacyMetadata;

    public Country() {
    }

    private Country(CharSequence code) {
        super(code);
        this.detectVersion();
    }

    private Country(Context context2, String codeListValue, String codeSpace, String value) {
        this.identifier = new CodeListUID(context2, "Country", codeListValue, codeSpace, value);
        this.detectVersion();
    }

    private void detectVersion() {
        this.isLegacyMetadata = !FilterByVersion.CURRENT_METADATA.accept();
    }

    @XmlElement(name="Country", namespace="http://www.isotc211.org/2005/gmd")
    public CodeListUID getCountry() {
        return this.isLegacyMetadata ? this.identifier : null;
    }

    public void setCountry(CodeListUID newValue) {
        this.identifier = newValue;
    }

    @XmlElement(name="CountryCode")
    public CodeListUID getCountryCode() {
        return this.isLegacyMetadata ? null : this.identifier;
    }

    public void setCountryCode(CodeListUID newValue) {
        this.identifier = newValue;
    }

    public static Country create(Context context2, Locale locale) {
        String codeListValue = Context.converter(context2).toCountryCode(context2, locale);
        if (codeListValue != null) {
            CharSequence string;
            if (!codeListValue.isEmpty() && Context.isFlagSet(context2, 4) && (string = CharSequenceAdapter.value(context2, locale, codeListValue)) != null) {
                return new Country(string);
            }
            Locale marshalLocale = LanguageCode.marshalLocale(context2);
            String codeSpace = Context.converter(context2).toLanguageCode(context2, marshalLocale);
            String value = locale.getDisplayCountry(marshalLocale);
            if (value.isEmpty()) {
                codeSpace = null;
                value = null;
            }
            if (!codeListValue.isEmpty() || value != null) {
                return new Country(context2, codeListValue, codeSpace, value);
            }
        }
        return null;
    }

    public static Locale getLocale(Context context2, LanguageCode language, Country country, Class<?> caller) {
        CodeListUID identifier;
        String c;
        Object code = null;
        if (language != null) {
            code = language.getLanguage();
        }
        if (country != null && (c = Strings.trimOrNull(((identifier = country.identifier) != null ? identifier : country).toString())) != null) {
            int i;
            if (code == null) {
                code = "";
            }
            if ((i = ((String)code).indexOf(95)) < 0) {
                code = (String)code + "_" + c;
            } else {
                int length = ((String)code).length();
                if (++i == ((String)code).length() || ((String)code).charAt(i) == '_') {
                    code = new StringBuilder().append((CharSequence)code, 0, i).append(c).append((CharSequence)code, i, length).toString();
                } else if (!c.equals(CharSequences.token((CharSequence)code, i))) {
                    Context.warningOccured(context2, caller, "unmarshal", Errors.class, (short)63, "country");
                }
            }
        }
        return Context.converter(context2).toLocale(context2, (String)code);
    }
}

