/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.TargetOps;
import org.apache.jena.shacl.engine.TargetType;
import org.apache.jena.shacl.lib.ShLib;

public class Target {
    private TargetType targetType;
    private Node node;
    private Graph shapesGraph;
    private BiFunction<Graph, Target, Collection<Node>> focusNodes;

    public static Target create(Node node, TargetType targetType, Node targetObj, Graph shapesGraph) {
        BiFunction<Graph, Target, Collection<Node>> focusNodes = Target.focusNodeFunction(targetType);
        return new Target(targetType, targetObj, shapesGraph, focusNodes);
    }

    private static BiFunction<Graph, Target, Collection<Node>> focusNodeFunction(TargetType targetType) {
        switch (targetType) {
            case implicitClass: {
                return TargetOps::focusImplicitClass;
            }
            case targetClass: {
                return TargetOps::focusTargetClass;
            }
            case targetNode: {
                return TargetOps::focusTargetNode;
            }
            case targetSubjectsOf: {
                return TargetOps::focusSubjectsOf;
            }
            case targetObjectsOf: {
                return TargetOps::focusObjectsOf;
            }
            case targetExtension: {
                return TargetOps::focusTargetExt;
            }
        }
        throw new InternalErrorException();
    }

    public Target(TargetType decl, Node obj, Graph shapesGraph, BiFunction<Graph, Target, Collection<Node>> focusNodes) {
        this.targetType = decl;
        this.node = obj;
        this.shapesGraph = shapesGraph;
        this.focusNodes = focusNodes;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public Node getObject() {
        return this.node;
    }

    public Collection<Node> getFocusNodes(Graph data) {
        return this.focusNodes.apply(data, this);
    }

    public Graph getShapesGraph() {
        return this.shapesGraph;
    }

    public String toString() {
        return this.getTargetType().name() + "[" + ShLib.displayStr(this.getObject()) + "]";
    }
}

