/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.util.Map;
import java.util.SplittableRandom;
import org.apache.lucene.backward_codecs.lucene90.Lucene90OnHeapHnswGraph;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class Lucene90HnswVectorsReader
extends KnnVectorsReader {
    private final IntObjectHashMap<FieldEntry> fields;
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final long checksumSeed;
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Lucene90HnswVectorsReader(SegmentReadState state) throws IOException {
        long[] checksumRef;
        block3: {
            this.fields = new IntObjectHashMap();
            int versionMeta = this.readMetadata(state);
            checksumRef = new long[1];
            this.fieldInfos = state.fieldInfos;
            boolean success = false;
            try {
                this.vectorData = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene90HnswVectorsFormatData", checksumRef);
                this.vectorIndex = Lucene90HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene90HnswVectorsFormatIndex", checksumRef);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this);
        }
        this.checksumSeed = checksumRef[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene90HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, long[] checksumRef) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                checksumRef[0] = CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.number, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf((Object)similarityFunction) + " != " + String.valueOf((Object)info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, info.getVectorSimilarityFunction());
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    private FieldEntry getFieldEntry(String field) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        return fieldEntry;
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.getOffHeapVectorValues(this.getFieldEntry(field));
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        if (fieldEntry.size() == 0) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = this.getOffHeapVectorValues(fieldEntry);
        SplittableRandom random = new SplittableRandom(this.checksumSeed);
        NeighborQueue results = Lucene90OnHeapHnswGraph.search(target, knnCollector.k(), knnCollector.k(), vectorValues, fieldEntry.similarityFunction, this.getGraphValues(fieldEntry), this.getAcceptOrds(acceptDocs.bits(), fieldEntry), knnCollector.visitLimit(), random);
        knnCollector.incVisitedCount(results.visitedCount());
        while (results.size() > 0) {
            int node = results.topNode();
            float minSimilarity = results.topScore();
            results.pop();
            knnCollector.collect(node, minSimilarity);
        }
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    private OffHeapFloatVectorValues getOffHeapVectorValues(FieldEntry fieldEntry) throws IOException {
        IndexInput bytesSlice = this.vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new OffHeapFloatVectorValues(fieldEntry.dimension, fieldEntry.ordToDoc, fieldEntry.similarityFunction, bytesSlice);
    }

    private Bits getAcceptOrds(final Bits acceptDocs, final FieldEntry fieldEntry) {
        if (acceptDocs == null) {
            return null;
        }
        return new Bits(){

            @Override
            public boolean get(int index) {
                return acceptDocs.get(fieldEntry.ordToDoc[index]);
            }

            @Override
            public int length() {
                return fieldEntry.ordToDoc.length;
            }
        };
    }

    private HnswGraph getGraphValues(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.indexDataOffset, entry.indexDataLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        FieldEntry entry = this.getFieldEntry(fieldInfo.name);
        Map.Entry<String, Long> raw = Map.entry("vec", entry.vectorDataLength);
        Map.Entry<String, Long> graph = Map.entry("vex", entry.indexDataLength);
        return Map.ofEntries(raw, graph);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData, this.vectorIndex);
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, long vectorDataOffset, long vectorDataLength, long indexDataOffset, long indexDataLength, int dimension, int[] ordToDoc, long[] ordOffsets) {
        static FieldEntry create(DataInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            long indexDataOffset = input.readVLong();
            long indexDataLength = input.readVLong();
            int dimension = input.readInt();
            int size = input.readInt();
            int[] ordToDoc = new int[size];
            for (int i = 0; i < size; ++i) {
                int doc;
                ordToDoc[i] = doc = input.readVInt();
            }
            long[] ordOffsets = new long[size];
            long offset = 0L;
            for (int i = 0; i < ordOffsets.length; ++i) {
                ordOffsets[i] = offset += input.readVLong();
            }
            return new FieldEntry(similarityFunction, vectorDataOffset, vectorDataLength, indexDataOffset, indexDataLength, dimension, ordToDoc, ordOffsets);
        }

        int size() {
            return this.ordToDoc.length;
        }
    }

    static class OffHeapFloatVectorValues
    extends FloatVectorValues {
        final int dimension;
        final int[] ordToDoc;
        final IndexInput dataIn;
        final int byteSize;
        int lastOrd = -1;
        final float[] value;
        final VectorSimilarityFunction similarityFunction;

        OffHeapFloatVectorValues(int dimension, int[] ordToDoc, VectorSimilarityFunction similarityFunction, IndexInput dataIn) {
            this.dimension = dimension;
            this.ordToDoc = ordToDoc;
            this.dataIn = dataIn;
            this.similarityFunction = similarityFunction;
            this.byteSize = 4 * dimension;
            this.value = new float[dimension];
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        @Override
        public int size() {
            return this.ordToDoc.length;
        }

        @Override
        public OffHeapFloatVectorValues copy() {
            return new OffHeapFloatVectorValues(this.dimension, this.ordToDoc, this.similarityFunction, this.dataIn.clone());
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            if (this.lastOrd == targetOrd) {
                return this.value;
            }
            this.dataIn.seek((long)targetOrd * (long)this.byteSize);
            this.dataIn.readFloats(this.value, 0, this.value.length);
            this.lastOrd = targetOrd;
            return this.value;
        }

        @Override
        public int ordToDoc(int ord) {
            return this.ordToDoc[ord];
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createSparseIterator();
        }

        @Override
        public VectorScorer scorer(final float[] target) {
            if (this.size() == 0) {
                return null;
            }
            final OffHeapFloatVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return values.similarityFunction.compare(values.vectorValue(iterator.index()), target);
                }

                @Override
                public KnnVectorValues.DocIndexIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final FieldEntry entry;
        final IndexInput dataIn;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.entry = entry;
            this.dataIn = dataIn;
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            this.dataIn.seek(this.entry.ordOffsets[targetOrd]);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int maxConn() {
            return -1;
        }

        @Override
        public int size() {
            return this.entry.size();
        }

        @Override
        public int neighborCount() {
            return this.arcCount;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc += this.dataIn.readVInt();
            return this.arc;
        }

        @Override
        public int numLevels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int entryNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            throw new UnsupportedOperationException();
        }
    }
}

