/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.reflect.Annotatable;
import org.apache.juneau.commons.reflect.AnnotatableType;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassArrayFormat;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ClassNameFormat;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ElementFlag;
import org.apache.juneau.commons.reflect.ElementInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.PackageInfo;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AnnotationUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.PredicateUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class ClassInfo
extends ElementInfo
implements Annotatable,
Type,
Comparable<ClassInfo> {
    private static final Cache<Class, ClassInfoTyped> CACHE = Cache.of(Class.class, ClassInfoTyped.class).build();
    public static final ClassInfo OBJECT = ClassInfo.of(Object.class);
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static final Map<Class, Object> primitiveDefaultMap;
    private final Type innerType;
    private final Class<?> inner;
    private final boolean isParameterizedType;
    private final Supplier<Integer> dimensions;
    private final Supplier<ClassInfo> componentType;
    private final Supplier<PackageInfo> packageInfo;
    private final Supplier<List<ClassInfo>> parents;
    private final Supplier<List<AnnotationInfo>> declaredAnnotations;
    private final Supplier<String> fullName;
    private final Supplier<String> shortName;
    private final Supplier<String> readableName;
    private final Supplier<List<ClassInfo>> declaredInterfaces;
    private final Supplier<List<ClassInfo>> interfaces;
    private final Supplier<List<ClassInfo>> allParents;
    private final Supplier<List<ClassInfo>> parentsAndInterfaces;
    private final Supplier<List<AnnotationInfo<? extends Annotation>>> annotationInfos;
    private final Supplier<List<RecordComponent>> recordComponents;
    private final Supplier<List<Type>> genericInterfaces;
    private final Supplier<List<TypeVariable<?>>> typeParameters;
    private final Supplier<List<AnnotatedType>> annotatedInterfaces;
    private final Supplier<List<Object>> signers;
    private final Supplier<List<MethodInfo>> publicMethods;
    private final Supplier<List<MethodInfo>> declaredMethods;
    private final Supplier<List<MethodInfo>> allMethods;
    private final Supplier<List<MethodInfo>> allMethodsTopDown;
    private final Supplier<List<FieldInfo>> publicFields;
    private final Supplier<List<FieldInfo>> declaredFields;
    private final Supplier<List<FieldInfo>> allFields;
    private final Supplier<List<ConstructorInfo>> publicConstructors;
    private final Supplier<List<ConstructorInfo>> declaredConstructors;
    private final Supplier<MethodInfo> repeatedAnnotationMethod;
    private final Cache<Method, MethodInfo> methodCache;
    private final Cache<Field, FieldInfo> fieldCache;
    private final Cache<Constructor, ConstructorInfo> constructorCache;

    public static ClassInfo of(Class<?> inner, Type innerType) {
        if (inner == innerType) {
            return ClassInfo.of(inner);
        }
        if (inner != null) {
            return new ClassInfoTyped(inner, innerType);
        }
        return new ClassInfo(null, innerType);
    }

    public static <T> ClassInfoTyped<T> of(Class<T> inner) {
        return CACHE.get(inner, () -> new ClassInfoTyped(inner));
    }

    public static ClassInfo of(Object object) {
        Class object2;
        return ClassInfo.of(object instanceof Class ? (object2 = (Class)object) : object.getClass());
    }

    public static ClassInfo of(Type innerType) {
        if (innerType instanceof Class) {
            Class c = (Class)innerType;
            return ClassInfo.of(c);
        }
        return new ClassInfo(ClassUtils.toClass(innerType), innerType);
    }

    public static ClassInfo ofProxy(Object object) {
        Class<?> inner = ClassUtils.getProxyFor(object);
        return inner == null ? ClassInfo.of(object) : ClassInfo.of(inner);
    }

    protected ClassInfo(Class<?> inner, Type innerType) {
        super(inner == null ? 0 : inner.getModifiers());
        AssertionUtils.assertArg(inner != null || innerType != null, "At least one of inner or innerType must be specified.", new Object[0]);
        this.innerType = innerType;
        this.inner = inner;
        this.isParameterizedType = innerType == null ? false : innerType instanceof ParameterizedType;
        this.dimensions = Utils.mem(this::findDimensions);
        this.componentType = Utils.mem(this::findComponentType);
        this.packageInfo = Utils.mem(() -> Utils.opt(inner).map(x -> x.getPackage()).filter(p -> p != null).map(PackageInfo::of).orElse(null));
        this.parents = Utils.mem(this::findParents);
        this.declaredAnnotations = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.u(CollectionUtils.l(x.getDeclaredAnnotations()))).orElse(CollectionUtils.liste()).stream().flatMap(a -> AnnotationUtils.streamRepeated(a)).map(a -> this.ai(this, a)).toList());
        this.fullName = Utils.mem(() -> this.getNameFormatted(ClassNameFormat.FULL, true, '$', ClassArrayFormat.BRACKETS));
        this.shortName = Utils.mem(() -> this.getNameFormatted(ClassNameFormat.SHORT, true, '$', ClassArrayFormat.BRACKETS));
        this.readableName = Utils.mem(() -> this.getNameFormatted(ClassNameFormat.SIMPLE, false, '$', ClassArrayFormat.WORD));
        this.declaredInterfaces = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getGenericInterfaces()).map(ClassInfo::of).map(ClassInfo.class::cast).toList()).orElse(CollectionUtils.liste()));
        this.interfaces = Utils.mem(() -> this.getParents().stream().flatMap(x -> x.getDeclaredInterfaces().stream()).flatMap(ci2 -> Stream.concat(Stream.of(ci2), ci2.getInterfaces().stream())).distinct().toList());
        this.allParents = Utils.mem(() -> Stream.concat(this.getParents().stream(), this.getInterfaces().stream()).toList());
        this.parentsAndInterfaces = Utils.mem(this::findParentsAndInterfaces);
        this.annotationInfos = Utils.mem(this::findAnnotations);
        this.recordComponents = Utils.mem(() -> Utils.opt(inner).filter(Class::isRecord).map(x -> CollectionUtils.u(CollectionUtils.l(x.getRecordComponents()))).orElse(CollectionUtils.liste()));
        this.genericInterfaces = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.u(CollectionUtils.l(x.getGenericInterfaces()))).orElse(CollectionUtils.liste()));
        this.typeParameters = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.u(CollectionUtils.l(x.getTypeParameters()))).orElse(CollectionUtils.liste()));
        this.annotatedInterfaces = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.u(CollectionUtils.l(x.getAnnotatedInterfaces()))).orElse(CollectionUtils.liste()));
        this.signers = Utils.mem(() -> Utils.opt(inner).map(Class::getSigners).map(x -> CollectionUtils.u(CollectionUtils.l(x))).orElse(CollectionUtils.liste()));
        this.publicMethods = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getMethods()).filter(m -> Utils.neq(m.getDeclaringClass(), Object.class)).map(this::getMethod).sorted().toList()).orElse(CollectionUtils.liste()));
        this.declaredMethods = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getDeclaredMethods()).filter(m -> Utils.neq("$jacocoInit", m.getName())).map(this::getMethod).sorted().toList()).orElse(CollectionUtils.liste()));
        this.allMethods = Utils.mem(() -> this.allParents.get().stream().flatMap(c2 -> c2.getDeclaredMethods().stream()).toList());
        this.allMethodsTopDown = Utils.mem(() -> CollectionUtils.rstream(this.getAllParents()).flatMap(c2 -> c2.getDeclaredMethods().stream()).toList());
        this.publicFields = Utils.mem(() -> this.parents.get().stream().flatMap(c2 -> c2.getDeclaredFields().stream()).filter(f -> f.isPublic() && Utils.neq("$jacocoData", f.getName())).collect(Collectors.toMap(FieldInfo::getName, x -> x, (a, b) -> a, LinkedHashMap::new)).values().stream().sorted().collect(Collectors.toList()));
        this.declaredFields = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getDeclaredFields()).filter(f -> Utils.neq("$jacocoData", f.getName())).map(this::getField).sorted().toList()).orElse(CollectionUtils.liste()));
        this.allFields = Utils.mem(() -> CollectionUtils.rstream(this.allParents.get()).flatMap(c2 -> c2.getDeclaredFields().stream()).toList());
        this.publicConstructors = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getConstructors()).map(this::getConstructor).sorted().toList()).orElse(CollectionUtils.liste()));
        this.declaredConstructors = Utils.mem(() -> Utils.opt(inner).map(x -> CollectionUtils.stream(x.getDeclaredConstructors()).map(this::getConstructor).sorted().toList()).orElse(CollectionUtils.liste()));
        this.repeatedAnnotationMethod = Utils.mem(this::findRepeatedAnnotationMethod);
        this.methodCache = Cache.of(Method.class, MethodInfo.class).build();
        this.fieldCache = Cache.of(Field.class, FieldInfo.class).build();
        this.constructorCache = Cache.of(Constructor.class, ConstructorInfo.class).build();
    }

    public StringBuilder appendNameFormatted(StringBuilder sb, ClassNameFormat nameFormat, boolean includeTypeParams, char separator, ClassArrayFormat arrayFormat) {
        int dim = this.getDimensions();
        if (dim > 0) {
            ClassInfo componentType = this.getComponentType();
            componentType.appendNameFormatted(sb, nameFormat, includeTypeParams, separator, arrayFormat);
            if (arrayFormat == ClassArrayFormat.WORD) {
                for (int i = 0; i < dim; ++i) {
                    sb.append("Array");
                }
            } else if (arrayFormat == ClassArrayFormat.BRACKETS) {
                for (int i = 0; i < dim; ++i) {
                    sb.append("[]");
                }
            }
            return sb;
        }
        Class ct = this.inner;
        if (ct == null && this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.innerType;
            ct = (Class)pt.getRawType();
        }
        switch (nameFormat) {
            case FULL: {
                if (Utils.nn(ct)) {
                    sb.append(ct.getName());
                    if (separator == '$' || sb.indexOf("$") == -1) break;
                    for (int i = 0; i < sb.length(); ++i) {
                        if (sb.charAt(i) != '$') continue;
                        sb.setCharAt(i, separator);
                    }
                    break;
                }
                sb.append(this.innerType.getTypeName());
                break;
            }
            case SHORT: {
                if (Utils.nn(ct)) {
                    if (ct.isLocalClass()) {
                        sb.append(ClassInfo.of(ct.getEnclosingClass()).getNameSimple()).append(separator).append(ct.getSimpleName());
                        break;
                    }
                    if (ct.isMemberClass()) {
                        sb.append(ClassInfo.of(ct.getDeclaringClass()).getNameSimple()).append(separator).append(ct.getSimpleName());
                        break;
                    }
                    sb.append(ct.getSimpleName());
                    break;
                }
                sb.append(this.innerType.getTypeName());
                break;
            }
            default: {
                if (Utils.nn(ct)) {
                    sb.append(ct.getSimpleName());
                    break;
                }
                sb.append(this.innerType.getTypeName());
            }
        }
        if (includeTypeParams && this.isParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.innerType;
            sb.append('<');
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                ClassInfo.of(t2).appendNameFormatted(sb, nameFormat, includeTypeParams, separator, arrayFormat);
            }
            sb.append('>');
        }
        return sb;
    }

    public ClassInfo arrayType() {
        if (this.inner == null) {
            return null;
        }
        return ClassInfo.of(this.inner.arrayType());
    }

    public <U> ClassInfo asSubclass(Class<U> clazz) {
        if (this.inner == null) {
            return null;
        }
        this.inner.asSubclass(clazz);
        return this;
    }

    public boolean canAcceptArg(Object child) {
        if (this.inner == null) {
            return false;
        }
        if (child == null) {
            return !this.isPrimitive();
        }
        if (this.inner.isInstance(child)) {
            return true;
        }
        if (this.isPrimitive()) {
            return this.getWrapperIfPrimitive().isParentOf(ClassInfo.of(child).getWrapperIfPrimitive());
        }
        return false;
    }

    public <T> T cast(Object obj) {
        return this.inner == null ? null : (T)this.inner.cast(obj);
    }

    public ClassInfo componentType() {
        if (this.inner == null) {
            return null;
        }
        TypeDescriptor.OfField ct = this.inner.componentType();
        return ct == null ? null : ClassInfo.of(ct);
    }

    public String descriptorString() {
        return this.inner == null ? null : this.inner.descriptorString();
    }

    public boolean equals(Object o) {
        ClassInfo o2;
        return o instanceof ClassInfo && Utils.eq(this, o2 = (ClassInfo)o, (x, y) -> Utils.eq(x.innerType, y.innerType));
    }

    @Override
    public int compareTo(ClassInfo o) {
        if (o == null) {
            return 1;
        }
        return Utils.cmp(this.getName(), o.getName());
    }

    public List<FieldInfo> getAllFields() {
        return this.allFields.get();
    }

    public List<MethodInfo> getAllMethods() {
        return this.allMethods.get();
    }

    public List<MethodInfo> getAllMethodsTopDown() {
        return this.allMethodsTopDown.get();
    }

    public List<ClassInfo> getAllParents() {
        return this.allParents.get();
    }

    @Override
    public AnnotatableType getAnnotatableType() {
        return AnnotatableType.CLASS_TYPE;
    }

    public List<AnnotatedType> getAnnotatedInterfaces() {
        return this.annotatedInterfaces.get();
    }

    public AnnotatedType getAnnotatedSuperclass() {
        return this.inner == null ? null : this.inner.getAnnotatedSuperclass();
    }

    public List<AnnotationInfo<? extends Annotation>> getAnnotations() {
        return this.annotationInfos.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> type) {
        AssertionUtils.assertArgNotNull("type", type);
        return this.getAnnotations().stream().filter(a -> a.isType(type)).map(a -> a);
    }

    public ClassLoader getClassLoader() {
        return this.inner == null ? null : this.inner.getClassLoader();
    }

    public ClassInfo getComponentType() {
        return this.componentType.get();
    }

    public List<AnnotationInfo> getDeclaredAnnotations() {
        return this.declaredAnnotations.get();
    }

    public Optional<ConstructorInfo> getDeclaredConstructor(Predicate<ConstructorInfo> filter) {
        return this.declaredConstructors.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<ConstructorInfo> getDeclaredConstructors() {
        return this.declaredConstructors.get();
    }

    public Optional<FieldInfo> getDeclaredField(Predicate<FieldInfo> filter) {
        return this.declaredFields.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<FieldInfo> getDeclaredFields() {
        return this.declaredFields.get();
    }

    public List<ClassInfo> getDeclaredInterfaces() {
        return this.declaredInterfaces.get();
    }

    public List<ClassInfo> getDeclaredMemberClasses() {
        if (this.inner == null) {
            return CollectionUtils.u(CollectionUtils.l(new ClassInfo[0]));
        }
        Class<?>[] classes = this.inner.getDeclaredClasses();
        ArrayList<ClassInfoTyped<?>> l = CollectionUtils.listOfSize(classes.length);
        for (Class<?> cc : classes) {
            l.add(ClassInfo.of(cc));
        }
        return CollectionUtils.u(l);
    }

    public Optional<MethodInfo> getDeclaredMethod(Predicate<MethodInfo> filter) {
        return this.declaredMethods.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<MethodInfo> getDeclaredMethods() {
        return this.declaredMethods.get();
    }

    public ClassInfo getDeclaringClass() {
        if (this.inner == null) {
            return null;
        }
        Class<?> dc = this.inner.getDeclaringClass();
        return dc == null ? null : ClassInfo.of(dc);
    }

    public int getDimensions() {
        return this.dimensions.get();
    }

    public ClassInfo getEnclosingClass() {
        if (this.inner == null) {
            return null;
        }
        Class<?> ec = this.inner.getEnclosingClass();
        return ec == null ? null : ClassInfo.of(ec);
    }

    public ConstructorInfo getEnclosingConstructor() {
        if (this.inner == null) {
            return null;
        }
        Constructor<?> ec = this.inner.getEnclosingConstructor();
        return ec == null ? null : this.getConstructor(ec);
    }

    public MethodInfo getEnclosingMethod() {
        if (this.inner == null) {
            return null;
        }
        Method em = this.inner.getEnclosingMethod();
        return em == null ? null : this.getMethod(em);
    }

    public List<Type> getGenericInterfaces() {
        return this.genericInterfaces.get();
    }

    public Type getGenericSuperclass() {
        return this.inner == null ? null : this.inner.getGenericSuperclass();
    }

    public List<ClassInfo> getInterfaces() {
        return this.interfaces.get();
    }

    @Override
    public String getLabel() {
        return this.getNameSimple();
    }

    public List<ClassInfo> getMemberClasses() {
        if (this.inner == null) {
            return CollectionUtils.u(CollectionUtils.l(new ClassInfo[0]));
        }
        Class<?>[] classes = this.inner.getClasses();
        ArrayList<ClassInfoTyped<?>> l = CollectionUtils.listOfSize(classes.length);
        for (Class<?> cc : classes) {
            l.add(ClassInfo.of(cc));
        }
        return CollectionUtils.u(l);
    }

    public Optional<MethodInfo> getMethod(Predicate<MethodInfo> filter) {
        return this.allMethods.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public Module getModule() {
        return this.inner == null ? null : this.inner.getModule();
    }

    public String getName() {
        return Utils.nn(this.inner) ? this.inner.getName() : this.innerType.getTypeName();
    }

    public String getNameCanonical() {
        if (this.inner != null && !this.isParameterizedType) {
            return this.inner.getCanonicalName();
        }
        return null;
    }

    public String getNameFormatted(ClassNameFormat nameFormat, boolean includeTypeParams, char separator, ClassArrayFormat arrayFormat) {
        StringBuilder sb = new StringBuilder(128);
        this.appendNameFormatted(sb, nameFormat, includeTypeParams, separator, arrayFormat);
        return sb.toString();
    }

    public String getNameFull() {
        return this.fullName.get();
    }

    public String getNameReadable() {
        return this.readableName.get();
    }

    public String[] getNames() {
        return CollectionUtils.a(this.getNameFull(), this.inner.getName(), this.getNameShort(), this.getNameSimple());
    }

    public String getNameShort() {
        return this.shortName.get();
    }

    public String getNameSimple() {
        return Utils.nn(this.inner) ? this.inner.getSimpleName() : this.innerType.getTypeName();
    }

    public ClassInfo getNestHost() {
        if (this.inner == null) {
            return null;
        }
        return ClassInfo.of(this.inner.getNestHost());
    }

    public List<ClassInfo> getNestMembers() {
        if (this.inner == null) {
            return CollectionUtils.u(CollectionUtils.l(new ClassInfo[0]));
        }
        Class<?>[] members = this.inner.getNestMembers();
        ArrayList<ClassInfoTyped<?>> l = CollectionUtils.listOfSize(members.length);
        for (Class<?> cc : members) {
            l.add(ClassInfo.of(cc));
        }
        return CollectionUtils.u(l);
    }

    public Optional<ConstructorInfo> getNoArgConstructor(Visibility v) {
        if (this.isAbstract()) {
            return Utils.opte();
        }
        int expectedParams = this.isNonStaticMemberClass() ? 1 : 0;
        return this.getDeclaredConstructors().stream().filter(cc -> cc.hasNumParameters(expectedParams)).filter(cc -> cc.isVisible(v)).map(cc -> cc.accessible()).findFirst();
    }

    public PackageInfo getPackage() {
        return this.packageInfo.get();
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> type) {
        PackageInfo pi = this.getPackage();
        if (pi == null) {
            return null;
        }
        AnnotationInfo ai = pi.getAnnotations(type).findFirst().orElse(null);
        return ai == null ? null : (A)ai.inner();
    }

    public Class<?> getParameterType(int index, Class<?> pt) {
        AssertionUtils.assertArgNotNull("pt", pt);
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> cc = this.inner;
        while (pt != cc.getSuperclass()) {
            ClassInfo.extractTypes(typeMap, cc);
            cc = cc.getSuperclass();
            AssertionUtils.assertArg(Utils.nn(cc), "Class ''{0}'' is not a subclass of parameterized type ''{1}''", this.inner.getSimpleName(), pt.getSimpleName());
        }
        Type gsc = cc.getGenericSuperclass();
        AssertionUtils.assertArg(gsc instanceof ParameterizedType, "Class ''{0}'' is not a parameterized type", pt.getSimpleName());
        ParameterizedType cpt = (ParameterizedType)gsc;
        Type[] atArgs = cpt.getActualTypeArguments();
        AssertionUtils.assertArg(index < atArgs.length, "Invalid type index. index={0}, argsLength={1}", index, atArgs.length);
        Type actualType = cpt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            Class actualType2 = (Class)actualType;
            return actualType2;
        }
        if (actualType instanceof GenericArrayType) {
            GenericArrayType actualType2 = (GenericArrayType)actualType;
            Type gct = actualType2.getGenericComponentType();
            if (gct instanceof ParameterizedType) {
                ParameterizedType gct2 = (ParameterizedType)gct;
                return Array.newInstance((Class)gct2.getRawType(), 0).getClass();
            }
        } else if (actualType instanceof TypeVariable) {
            TypeVariable actualType3 = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            Class<?> ec = cc.getEnclosingClass();
            while (Utils.nn(ec)) {
                Class<?> outerClass = ec;
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ClassInfo.extractTypes(outerTypeMap, outerClass);
                for (Map.Entry<Type, Type> entry : outerTypeMap.entrySet()) {
                    TypeVariable key2;
                    Type key = entry.getKey();
                    Type value = entry.getValue();
                    if (!(key instanceof TypeVariable) || !(key2 = (TypeVariable)key).getName().equals(actualType3.getName()) || !ClassInfo.isInnerClass(key2.getGenericDeclaration(), actualType3.getGenericDeclaration())) continue;
                    if (value instanceof Class) {
                        Class value2 = (Class)value;
                        return value2;
                    }
                    actualType3 = (TypeVariable)entry.getValue();
                }
                ec = ec.getEnclosingClass();
            }
        } else if (actualType instanceof ParameterizedType) {
            ParameterizedType actualType2 = (ParameterizedType)actualType;
            return (Class)actualType2.getRawType();
        }
        throw ThrowableUtils.illegalArg("Could not resolve variable ''{0}'' to a type.", actualType.getTypeName());
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType gs2 = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)gs2.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = gs2.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class) {
            Class oc = (Class)od;
            if (id instanceof Class) {
                Class<?> ic = (Class<?>)id;
                while (Utils.nn(ic = ic.getEnclosingClass())) {
                    if (ic != oc) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<ClassInfo> getParents() {
        return this.parents.get();
    }

    public List<ClassInfo> getParentsAndInterfaces() {
        return this.parentsAndInterfaces.get();
    }

    public List<ClassInfo> getPermittedSubclasses() {
        if (this.inner == null || !this.inner.isSealed()) {
            return CollectionUtils.u(CollectionUtils.l(new ClassInfo[0]));
        }
        return CollectionUtils.u(CollectionUtils.stream(this.inner.getPermittedSubclasses()).map(ClassInfo::of).toList());
    }

    public Object getPrimitiveDefault() {
        return primitiveDefaultMap.get(this.inner);
    }

    public Class<?> getPrimitiveForWrapper() {
        return pmap2.get(this.inner);
    }

    public Class<?> getPrimitiveWrapper() {
        return pmap1.get(this.inner);
    }

    public ProtectionDomain getProtectionDomain() {
        return this.inner == null ? null : this.inner.getProtectionDomain();
    }

    public Optional<ConstructorInfo> getPublicConstructor(Predicate<ConstructorInfo> filter) {
        return this.publicConstructors.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<ConstructorInfo> getPublicConstructors() {
        return this.publicConstructors.get();
    }

    public Optional<FieldInfo> getPublicField(Predicate<FieldInfo> filter) {
        return this.publicFields.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<FieldInfo> getPublicFields() {
        return this.publicFields.get();
    }

    public Optional<MethodInfo> getPublicMethod(Predicate<MethodInfo> filter) {
        return this.publicMethods.get().stream().filter(x -> PredicateUtils.test(filter, x)).findFirst();
    }

    public List<MethodInfo> getPublicMethods() {
        return this.publicMethods.get();
    }

    public List<RecordComponent> getRecordComponents() {
        return this.recordComponents.get();
    }

    public MethodInfo getRepeatedAnnotationMethod() {
        return this.repeatedAnnotationMethod.get();
    }

    public URL getResource(String name) {
        return this.inner == null ? null : this.inner.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.inner == null ? null : this.inner.getResourceAsStream(name);
    }

    public List<Object> getSigners() {
        return this.signers.get();
    }

    public ClassInfo getSuperclass() {
        if (this.inner == null) {
            return null;
        }
        Class<?> sc = this.inner.getSuperclass();
        return sc == null ? null : ClassInfo.of(sc);
    }

    public List<TypeVariable<?>> getTypeParameters() {
        return this.typeParameters.get();
    }

    public ClassInfo getWrapperIfPrimitive() {
        if (this.inner == null || !this.inner.isPrimitive()) {
            return this;
        }
        return ClassInfo.of(pmap1.get(this.inner));
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> type) {
        return this.getAnnotations(type).findFirst().isPresent();
    }

    public int hashCode() {
        return this.innerType.hashCode();
    }

    public boolean hasPackage() {
        return Utils.nn(this.getPackage());
    }

    public boolean hasPrimitiveWrapper() {
        return pmap1.containsKey(this.inner);
    }

    public <T> Class<T> inner() {
        return this.inner;
    }

    public Type innerType() {
        return this.innerType;
    }

    public boolean is(Class<?> c) {
        return Utils.nn(this.inner) && this.inner.equals(c);
    }

    public boolean is(ClassInfo c) {
        if (Utils.nn(this.inner)) {
            return this.inner.equals(c.inner());
        }
        return this.innerType.equals(c.innerType);
    }

    @Override
    public boolean is(ElementFlag flag) {
        return switch (flag) {
            case ElementFlag.ANNOTATION -> this.isAnnotation();
            case ElementFlag.NOT_ANNOTATION -> {
                if (!this.isAnnotation()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.ANONYMOUS -> this.isAnonymousClass();
            case ElementFlag.NOT_ANONYMOUS -> {
                if (!this.isAnonymousClass()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.ARRAY -> this.isArray();
            case ElementFlag.NOT_ARRAY -> {
                if (!this.isArray()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.CLASS -> {
                if (!this.isInterface()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.DEPRECATED -> this.isDeprecated();
            case ElementFlag.NOT_DEPRECATED -> this.isNotDeprecated();
            case ElementFlag.ENUM -> this.isEnum();
            case ElementFlag.NOT_ENUM -> {
                if (!this.isEnum()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.LOCAL -> this.isLocalClass();
            case ElementFlag.NOT_LOCAL -> {
                if (!this.isLocalClass()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.MEMBER -> this.isMemberClass();
            case ElementFlag.NOT_MEMBER -> this.isNotMemberClass();
            case ElementFlag.NON_STATIC_MEMBER -> this.isNonStaticMemberClass();
            case ElementFlag.NOT_NON_STATIC_MEMBER -> {
                if (!this.isNonStaticMemberClass()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.PRIMITIVE -> this.isPrimitive();
            case ElementFlag.NOT_PRIMITIVE -> {
                if (!this.isPrimitive()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.RECORD -> this.isRecord();
            case ElementFlag.NOT_RECORD -> {
                if (!this.isRecord()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.SEALED -> this.isSealed();
            case ElementFlag.NOT_SEALED -> {
                if (!this.isSealed()) {
                    yield true;
                }
                yield false;
            }
            case ElementFlag.SYNTHETIC -> this.isSynthetic();
            case ElementFlag.NOT_SYNTHETIC -> {
                if (!this.isSynthetic()) {
                    yield true;
                }
                yield false;
            }
            default -> super.is(flag);
        };
    }

    public boolean isAnnotation() {
        return Utils.nn(this.inner) && this.inner.isAnnotation();
    }

    public boolean isAnonymousClass() {
        return Utils.nn(this.inner) && this.inner.isAnonymousClass();
    }

    public boolean isAny(Class<?> ... types) {
        for (Class<?> cc : types) {
            if (!this.is(cc)) continue;
            return true;
        }
        return false;
    }

    public boolean isAny(Class<?> t1, Class<?> t2) {
        return this.inner == t1 || this.inner == t2;
    }

    public boolean isAny(Class<?> t1, Class<?> t2, Class<?> t3) {
        return this.inner == t1 || this.inner == t2 || this.inner == t3;
    }

    public boolean isAny(Class<?> t1, Class<?> t2, Class<?> t3, Class<?> t4) {
        return this.inner == t1 || this.inner == t2 || this.inner == t3 || this.inner == t4;
    }

    public boolean isAny(Class<?> t1, Class<?> t2, Class<?> t3, Class<?> t4, Class<?> t5) {
        return this.inner == t1 || this.inner == t2 || this.inner == t3 || this.inner == t4 || this.inner == t5;
    }

    public boolean isArray() {
        return Utils.nn(this.inner) && this.inner.isArray();
    }

    public boolean isChildOf(Class<?> parent) {
        return Utils.and(Utils.nn(this.inner), Utils.nn(parent)) && parent.isAssignableFrom(this.inner);
    }

    public boolean isChildOf(ClassInfo parent) {
        return this.isChildOf(parent.inner());
    }

    public boolean isChildOf(Type parent) {
        if (parent instanceof Class) {
            Class c = (Class)parent;
            return this.isChildOf(c);
        }
        return false;
    }

    public boolean isChildOfAny(Class<?> ... parents) {
        for (Class<?> p : parents) {
            if (!this.isChildOf(p)) continue;
            return true;
        }
        return false;
    }

    public boolean isClass() {
        return Utils.nn(this.inner) && !this.inner.isInterface();
    }

    public boolean isCollectionOrArray() {
        return Utils.nn(this.inner) && (Collection.class.isAssignableFrom(this.inner) || this.inner.isArray());
    }

    public boolean isDeprecated() {
        return Utils.nn(this.inner) && this.inner.isAnnotationPresent(Deprecated.class);
    }

    public boolean isEnum() {
        return Utils.nn(this.inner) && this.inner.isEnum();
    }

    public boolean isInstance(Object value) {
        if (Utils.nn(this.inner)) {
            return this.inner.isInstance(value);
        }
        return false;
    }

    public boolean isLocalClass() {
        return Utils.nn(this.inner) && this.inner.isLocalClass();
    }

    public boolean isMemberClass() {
        return Utils.nn(this.inner) && this.inner.isMemberClass();
    }

    public boolean isNestmateOf(Class<?> c) {
        return Utils.nn(this.inner) && Utils.nn(c) && this.inner.isNestmateOf(c);
    }

    public boolean isNonStaticMemberClass() {
        return Utils.nn(this.inner) && this.inner.isMemberClass() && !this.isStatic();
    }

    public boolean isNotDeprecated() {
        return this.inner == null || !this.inner.isAnnotationPresent(Deprecated.class);
    }

    public boolean isNotLocalClass() {
        return this.inner == null || !this.inner.isLocalClass();
    }

    public boolean isNotMemberClass() {
        return this.inner == null || !this.inner.isMemberClass();
    }

    public boolean isNotNonStaticMemberClass() {
        return !this.isNonStaticMemberClass();
    }

    public boolean isNotPrimitive() {
        return this.inner == null || !this.inner.isPrimitive();
    }

    public boolean isVoid() {
        return this.inner != null && (this.inner == Void.TYPE || this.inner == Void.class || this.inner.getSimpleName().equalsIgnoreCase("void"));
    }

    public boolean isNotVoid() {
        return !this.isVoid();
    }

    public boolean isParentOf(Class<?> child) {
        return Utils.nn(this.inner) && Utils.nn(child) && this.inner.isAssignableFrom(child);
    }

    public boolean isParentOf(ClassInfo child) {
        return Utils.nn(this.inner) && Utils.nn(child) && this.inner.isAssignableFrom(child.inner());
    }

    public boolean isParentOf(Type child) {
        if (child instanceof Class) {
            Class c = (Class)child;
            return this.isParentOf(c);
        }
        return false;
    }

    public boolean isParentOfLenient(Class<?> child) {
        if (this.inner == null || child == null) {
            return false;
        }
        if (this.inner.isAssignableFrom(child)) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isParentOf(ClassInfo.of(child).getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOfLenient(ClassInfo child) {
        if (this.inner == null || child == null) {
            return false;
        }
        if (this.inner.isAssignableFrom(child.inner())) {
            return true;
        }
        if (this.isPrimitive() || child.isPrimitive()) {
            return this.getWrapperIfPrimitive().isParentOf(child.getWrapperIfPrimitive());
        }
        return false;
    }

    public boolean isParentOfLenient(Type child) {
        if (child instanceof Class) {
            Class c = (Class)child;
            return this.isParentOfLenient(c);
        }
        return false;
    }

    public boolean isPrimitive() {
        return Utils.nn(this.inner) && this.inner.isPrimitive();
    }

    public boolean isRecord() {
        return Utils.nn(this.inner) && this.inner.isRecord();
    }

    public boolean isRepeatedAnnotation() {
        return this.getRepeatedAnnotationMethod() != null;
    }

    public boolean isRuntimeException() {
        return this.isChildOf(RuntimeException.class);
    }

    public boolean isSealed() {
        return Utils.nn(this.inner) && this.inner.isSealed();
    }

    public boolean isStrictChildOf(Class<?> parent) {
        return Utils.nn(this.inner) && Utils.nn(parent) && parent.isAssignableFrom(this.inner) && !this.inner.equals(parent);
    }

    public boolean isSynthetic() {
        return Utils.nn(this.inner) && this.inner.isSynthetic();
    }

    public boolean isVisible(Visibility v) {
        return Utils.nn(this.inner) && v.isVisible(this.inner);
    }

    public Object newInstance() throws ExecutableException {
        if (this.inner == null) {
            throw ThrowableUtils.exex("Type ''{0}'' cannot be instantiated", this.getNameFull());
        }
        try {
            return this.inner.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw ThrowableUtils.exex(e);
        }
    }

    public String toString() {
        return this.innerType.toString();
    }

    public ClassInfo unwrap(Class<?> ... wrapperTypes) {
        for (Class<?> wt : wrapperTypes) {
            Type t;
            if (!this.isParameterizedTypeOf(wt) || !Utils.nn(t = this.getFirstParameterType(wt))) continue;
            return ClassInfo.of(t).unwrap(wrapperTypes);
        }
        return this;
    }

    private void addInterfaceHierarchy(LinkedHashSet<ClassInfo> set, ClassInfo iface) {
        if (!set.add(iface)) {
            return;
        }
        List<ClassInfo> parentInterfaces = iface.getDeclaredInterfaces();
        for (int i = 0; i < parentInterfaces.size(); ++i) {
            this.addInterfaceHierarchy(set, parentInterfaces.get(i));
        }
    }

    private List<AnnotationInfo<? extends Annotation>> findAnnotations() {
        ArrayList list = new ArrayList();
        List<ClassInfo> parentsAndInterfaces = this.getParentsAndInterfaces();
        for (int i = 0; i < parentsAndInterfaces.size(); ++i) {
            ClassInfo ci = parentsAndInterfaces.get(i);
            for (Annotation a : ci.inner().getDeclaredAnnotations()) {
                AnnotationUtils.streamRepeated(a).forEach(a2 -> list.add(this.ai(ci, a2)));
            }
        }
        PackageInfo pkg = this.getPackage();
        if (Utils.nn(pkg)) {
            PackageInfo pi = PackageInfo.of(pkg.inner());
            for (Annotation a : pkg.inner().getAnnotations()) {
                AnnotationUtils.streamRepeated(a).forEach(a2 -> list.add(this.ai(pi, a2)));
            }
        }
        return CollectionUtils.u(list);
    }

    private ClassInfo findComponentType() {
        Type ct = this.innerType;
        Class<?> cc = this.inner;
        while (ct instanceof GenericArrayType) {
            GenericArrayType ct2 = (GenericArrayType)ct;
            ct = ct2.getGenericComponentType();
        }
        while (Utils.nn(cc) && cc.isArray()) {
            cc = cc.getComponentType();
        }
        if (ct != this.innerType) {
            return ClassInfo.of(ct);
        }
        if (cc != this.inner) {
            return ClassInfo.of(cc);
        }
        return this;
    }

    private int findDimensions() {
        int d = 0;
        Type ct = this.innerType;
        while (ct instanceof GenericArrayType) {
            GenericArrayType ct2 = (GenericArrayType)ct;
            ++d;
            ct = ct2.getGenericComponentType();
        }
        Class<?> cc = this.inner;
        while (Utils.nn(cc) && cc.isArray()) {
            ++d;
            cc = cc.getComponentType();
        }
        return d;
    }

    private List<ClassInfo> findParents() {
        List<ClassInfo> l = CollectionUtils.list(new ClassInfo[0]);
        for (Class<?> pc = this.inner; Utils.nn(pc) && pc != Object.class; pc = pc.getSuperclass()) {
            l.add(ClassInfo.of(pc));
        }
        return CollectionUtils.u(l);
    }

    private List<ClassInfo> findParentsAndInterfaces() {
        LinkedHashSet<ClassInfo> set = new LinkedHashSet<ClassInfo>();
        List<ClassInfo> parents = this.getParents();
        for (int i = 0; i < parents.size(); ++i) {
            ClassInfo parent = parents.get(i);
            set.add(parent);
            List<ClassInfo> declaredInterfaces = parent.getDeclaredInterfaces();
            for (int j = 0; j < declaredInterfaces.size(); ++j) {
                this.addInterfaceHierarchy(set, declaredInterfaces.get(j));
            }
        }
        return CollectionUtils.u(CollectionUtils.toList(set));
    }

    private MethodInfo findRepeatedAnnotationMethod() {
        return this.getPublicMethods().stream().filter(m -> m.hasName("value")).filter(m -> m.getReturnType().isArray()).filter(m -> {
            ClassInfo rct = m.getReturnType().getComponentType();
            if (rct.hasAnnotation(Repeatable.class)) {
                return ((Repeatable)rct.getAnnotations(Repeatable.class).findFirst().map(AnnotationInfo::inner).orElse(null)).value().equals(this.inner);
            }
            return false;
        }).findFirst().orElse(null);
    }

    private Type getFirstParameterType(Class<?> parameterizedType) {
        Type type = this.innerType;
        if (type instanceof ParameterizedType) {
            ParameterizedType innerType2 = (ParameterizedType)type;
            Type[] ta = innerType2.getActualTypeArguments();
            if (ta.length > 0) {
                return ta[0];
            }
        } else {
            Class innerType3;
            type = this.innerType;
            if (type instanceof Class && (innerType3 = (Class)type) != parameterizedType && parameterizedType.isAssignableFrom(innerType3)) {
                return ClassInfo.of(innerType3).getParameterType(0, parameterizedType);
            }
        }
        return null;
    }

    private boolean isParameterizedTypeOf(Class<?> c) {
        Class innerType2;
        ParameterizedType t2;
        Type type = this.innerType;
        return type instanceof ParameterizedType && (t2 = (ParameterizedType)type).getRawType() == c || (type = this.innerType) instanceof Class && c.isAssignableFrom(innerType2 = (Class)type);
    }

    ConstructorInfo getConstructor(Constructor<?> x) {
        return this.constructorCache.get(x, () -> new ConstructorInfo(this, x));
    }

    FieldInfo getField(Field x) {
        return this.fieldCache.get(x, () -> new FieldInfo(this, x));
    }

    MethodInfo getMethod(Method x) {
        return this.methodCache.get(x, () -> new MethodInfo(this, x));
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        primitiveDefaultMap = CollectionUtils.mapb(Class.class, Object.class).unmodifiable().add(Boolean.TYPE, false).add(Character.TYPE, Character.valueOf('\u0000')).add(Short.TYPE, (short)0).add(Integer.TYPE, 0).add(Long.TYPE, 0L).add(Float.TYPE, Float.valueOf(0.0f)).add(Double.TYPE, 0.0).add(Byte.TYPE, (byte)0).add(Boolean.class, false).add(Character.class, Character.valueOf('\u0000')).add(Short.class, (short)0).add(Integer.class, 0).add(Long.class, 0L).add(Float.class, Float.valueOf(0.0f)).add(Double.class, 0.0).add(Byte.class, (byte)0).build();
    }
}

