/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.rest.annotation.RestPostInit;

public class RestPostInitAnnotation {
    public static final RestPostInit DEFAULT = RestPostInitAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderM {
        private String[] description = new String[0];
        private boolean childFirst;

        protected Builder() {
            super(RestPostInit.class);
        }

        public RestPostInit build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder childFirst() {
            this.childFirst = true;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedAnnotationObject
    implements RestPostInit {
        private final String[] description;
        private final boolean childFirst;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.childFirst = b.childFirst;
        }

        @Override
        public boolean childFirst() {
            return this.childFirst;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public RestPostInit[] value();
    }
}

