/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaAlterLogDirsThread$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Accepted$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Effective$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$None$;
import kafka.server.ReplicaAlterLogDirsThread$ReassignmentState$Queued$;
import kafka.server.ReplicaAlterLogDirsTierStateMachine;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rUg\u0001\u00028p\u0001QD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\r\u0003\u001f\u0001!\u0011!Q\u0001\n\u0005E\u0011q\u0003\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u0011\u0001\t\u0005\t\u0015!\u0003\u0002$!Q\u0011\u0011\u0006\u0001\u0003\u0002\u0003\u0006I!a\u000b\t\u0019\u0005E\u0002A!A!\u0002\u0013\t\u0019$!\u000f\t\u0015\u0005m\u0002A!A!\u0002\u0013\ti\u0004\u0003\u0006\u0002F\u0001\u0011\t\u0011)A\u0005\u0003\u000fBq!a\u0018\u0001\t\u0003\t\t\u0007\u0003\u0006\u0002v\u0001\u0011\r\u0011\"\u0001p\u0003oB\u0001ba\u0003\u0001A\u0003%\u0011\u0011\u0010\u0005\b\u0007\u001b\u0001A\u0011KB\b\u0011\u001d\u00199\u0002\u0001C)\u00073Aqaa\t\u0001\t#\u001a)\u0003C\u0004\u0004*\u0001!\tfa\u000b\t\u000f\rm\u0002\u0001\"\u0011\u0004>!91q\r\u0001\u0005B\r%\u0004bBAa\u0001\u0011%1\u0011\u0011\u0005\t\u0007\u000f\u0003A\u0011A8\u0004\n\"91\u0011\u0013\u0001\u0005\n\rM\u0005bBBT\u0001\u0011\u00053\u0011\u0016\u0005\n\u0007o\u0003!\u0019!C)\u00033D\u0001b!/\u0001A\u0003%\u00111\u001c\u0005\b\u0007w\u0003A\u0011IB_\u0011\u001d\u0019Y\r\u0001C)\u0007\u001b<q!a)p\u0011\u0003\t)K\u0002\u0004o_\"\u0005\u0011q\u0015\u0005\b\u0003?ZB\u0011AAX\r\u0019\t\tl\u0007!\u00024\"Q\u0011\u0011Y\u000f\u0003\u0016\u0004%\t!a1\t\u0015\tMTD!E!\u0002\u0013\t)\r\u0003\u0006\u0003vu\u0011)\u001a!C\u0001\u0005oB!B!\"\u001e\u0005#\u0005\u000b\u0011\u0002B=\u0011)\u00119)\bBK\u0002\u0013\u0005!q\u000f\u0005\u000b\u0005\u0013k\"\u0011#Q\u0001\n\te\u0004bBA0;\u0011\u0005!1\u0012\u0005\b\u0005+kB\u0011\u0001BL\u0011%\u0011i*HA\u0001\n\u0003\u0011y\nC\u0005\u0003(v\t\n\u0011\"\u0001\u0003*\"I!qX\u000f\u0012\u0002\u0013\u0005!\u0011\u0019\u0005\n\u0005\u000bl\u0012\u0013!C\u0001\u0005\u0003D\u0011\"a>\u001e\u0003\u0003%\t%!?\t\u0013\t\u0015Q$!A\u0005\u0002\t\u001d\u0001\"\u0003B\u0005;\u0005\u0005I\u0011\u0001Bd\u0011%\u00119\"HA\u0001\n\u0003\u0012I\u0002C\u0005\u0003(u\t\t\u0011\"\u0001\u0003L\"I!QF\u000f\u0002\u0002\u0013\u0005#q\u0006\u0005\n\u0005ci\u0012\u0011!C!\u0005gA\u0011Ba4\u001e\u0003\u0003%\tE!5\b\u0013\tU7$!A\t\u0002\t]g!CAY7\u0005\u0005\t\u0012\u0001Bm\u0011\u001d\tyf\rC\u0001\u0005OD\u0011B!\r4\u0003\u0003%)Ea\r\t\u0013\t%8'!A\u0005\u0002\n-\b\"\u0003Bzg\u0005\u0005I\u0011\u0011B{\u0011%\u0011)dMA\u0001\n\u0013\u00119DB\u0005\u0002Jn\u0001\n1!\t\u0002L\"9\u0011QZ\u001d\u0005\u0002\u0005=\u0007bBAls\u0011\u0005\u0011\u0011\\\u0004\b\u0007\u0007Y\u0002\u0012AAu\r\u001d\tIm\u0007E\u0001\u0003KDq!a\u0018>\t\u0003\t9oB\u0004\u0002lvB\t)!<\u0007\u000f\u0005EX\b#!\u0002t\"9\u0011q\f!\u0005\u0002\u0005U\b\"CA|\u0001\u0006\u0005I\u0011IA}\u0011%\u0011)\u0001QA\u0001\n\u0003\u00119\u0001C\u0005\u0003\n\u0001\u000b\t\u0011\"\u0001\u0003\f!I!q\u0003!\u0002\u0002\u0013\u0005#\u0011\u0004\u0005\n\u0005O\u0001\u0015\u0011!C\u0001\u0005SA\u0011B!\fA\u0003\u0003%\tEa\f\t\u0013\tE\u0002)!A\u0005B\tM\u0002\"\u0003B\u001b\u0001\u0006\u0005I\u0011\u0002B\u001c\u000f\u001d\u0011y$\u0010EA\u0005\u00032qAa\u0011>\u0011\u0003\u0013)\u0005C\u0004\u0002`-#\tAa\u0012\t\u000f\u0005]7\n\"\u0011\u0002Z\"I\u0011q_&\u0002\u0002\u0013\u0005\u0013\u0011 \u0005\n\u0005\u000bY\u0015\u0011!C\u0001\u0005\u000fA\u0011B!\u0003L\u0003\u0003%\tA!\u0013\t\u0013\t]1*!A\u0005B\te\u0001\"\u0003B\u0014\u0017\u0006\u0005I\u0011\u0001B'\u0011%\u0011icSA\u0001\n\u0003\u0012y\u0003C\u0005\u00032-\u000b\t\u0011\"\u0011\u00034!I!QG&\u0002\u0002\u0013%!qG\u0004\b\u0005#j\u0004\u0012\u0011B*\r\u001d\t\u0019/\u0010EA\u0005OBq!a\u0018X\t\u0003\u0011I\u0007C\u0004\u0002X^#\t%!7\t\u0013\u0005]x+!A\u0005B\u0005e\b\"\u0003B\u0003/\u0006\u0005I\u0011\u0001B\u0004\u0011%\u0011IaVA\u0001\n\u0003\u0011Y\u0007C\u0005\u0003\u0018]\u000b\t\u0011\"\u0011\u0003\u001a!I!qE,\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005[9\u0016\u0011!C!\u0005_A\u0011B!\rX\u0003\u0003%\tEa\r\t\u0013\tUr+!A\u0005\n\t]ra\u0002B+{!\u0005%q\u000b\u0004\b\u00053j\u0004\u0012\u0011B.\u0011\u001d\tyf\u0019C\u0001\u0005;B\u0011\"a>d\u0003\u0003%\t%!?\t\u0013\t\u00151-!A\u0005\u0002\t\u001d\u0001\"\u0003B\u0005G\u0006\u0005I\u0011\u0001B0\u0011%\u00119bYA\u0001\n\u0003\u0012I\u0002C\u0005\u0003(\r\f\t\u0011\"\u0001\u0003d!I!QF2\u0002\u0002\u0013\u0005#q\u0006\u0005\n\u0005c\u0019\u0017\u0011!C!\u0005gA\u0011B!\u000ed\u0003\u0003%IAa\u000e\t\u0013\r\u00151$%A\u0005\u0002\r\u001d!!\u0007*fa2L7-Y!mi\u0016\u0014Hj\\4ESJ\u001cH\u000b\u001b:fC\u0012T!\u0001]9\u0002\rM,'O^3s\u0015\u0005\u0011\u0018!B6bM.\f7\u0001A\n\u0003\u0001U\u0004\"A^<\u000e\u0003=L!\u0001_8\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\rY\u0018\u0011\u0002\b\u0004y\u0006\u0015\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000g\u00061AH]8pizR!!a\u0001\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0011\u0011A\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0011Q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005\u001d\u0011\u0011A\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0007Y\f\u0019\"C\u0002\u0002\u0016=\u0014a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG/C\u0002\u0002\u0010]\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007Y\fi\"C\u0002\u0002 =\u0014\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002\u0015I,\u0007\u000f\\5dC6;'\u000fE\u0002w\u0003KI1!a\np\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u00042A^A\u0017\u0013\r\tyc\u001c\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\f\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\u0007Y\f)$C\u0002\u00028=\u0014\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\n\u0007\u0005Er/\u0001\bgKR\u001c\u0007NQ1dW>3g-T:\u0011\t\u0005}\u0012\u0011I\u0007\u0003\u0003\u0003IA!a\u0011\u0002\u0002\t\u0019\u0011J\u001c;\u0002+\u0011L'/Z2u_JLXI^3oi\"\u000bg\u000e\u001a7feB!\u0011\u0011JA.\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013AB2p[6|gNC\u0002q\u0003#R1A]A*\u0015\u0011\t)&a\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI&A\u0002pe\u001eLA!!\u0018\u0002L\t)B)\u001b:fGR|'/_#wK:$\b*\u00198eY\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\n\u0002d\u0005\u0015\u0014qMA5\u0003W\ni'a\u001c\u0002r\u0005M\u0004C\u0001<\u0001\u0011\u0015I\u0018\u00021\u0001{\u0011\u001d\ty!\u0003a\u0001\u0003#Aq!!\u0007\n\u0001\u0004\tY\u0002C\u0004\u0002\"%\u0001\r!a\t\t\u000f\u0005%\u0012\u00021\u0001\u0002,!9\u0011\u0011G\u0005A\u0002\u0005M\u0002bBA\u001e\u0013\u0001\u0007\u0011Q\b\u0005\n\u0003\u000bJ\u0001\u0013!a\u0001\u0003\u000f\nq\u0002\u001d:p[>$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003s\u0002\u0002\"a\u001f\u0002\n\u00065\u0015qS\u0007\u0003\u0003{RA!a \u0002\u0002\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0015QQ\u0001\u0005kRLGN\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\u0011\tY)! \u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0010\u0006MUBAAI\u0015\u0011\ti%!\u0015\n\t\u0005U\u0015\u0011\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\r\tI*\b\b\u0004\u00037Sb\u0002BAO\u0003Cs1!`AP\u0013\u0005\u0011\u0018B\u00019r\u0003e\u0011V\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014X-\u00193\u0011\u0005Y\\2cA\u000e\u0002*B!\u0011qHAV\u0013\u0011\ti+!\u0001\u0003\r\u0005s\u0017PU3g)\t\t)K\u0001\bQe>lw\u000e^5p]N#\u0018\r^3\u0014\u000fu\tI+!.\u0002<B!\u0011qHA\\\u0013\u0011\tI,!\u0001\u0003\u000fA\u0013x\u000eZ;diB!\u0011qHA_\u0013\u0011\ty,!\u0001\u0003\u0019M+'/[1mSj\f'\r\\3\u0002#I,\u0017m]:jO:lWM\u001c;Ti\u0006$X-\u0006\u0002\u0002FB\u0019\u0011qY\u001d\u000e\u0003m\u0011\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f'\rI\u0014\u0011V\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0005\u0005E\u0007\u0003BA \u0003'LA!!6\u0002\u0002\t!QK\\5u\u0003ei\u0017-\u001f2f\u0013:\u001cwN\\:jgR,g\u000e^'fi\u0006$\u0017\r^1\u0016\u0005\u0005m\u0007\u0003BA \u0003;LA!a8\u0002\u0002\t9!i\\8mK\u0006t\u0017&B\u001dXG\u0002[%\u0001C!dG\u0016\u0004H/\u001a3\u0014\u0007u\nI\u000b\u0006\u0002\u0002jB\u0019\u0011qY\u001f\u0002\t9{g.\u001a\t\u0004\u0003_\u0004U\"A\u001f\u0003\t9{g.Z\n\n\u0001\u0006%\u0016QYA[\u0003w#\"!!<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0010\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\u0011\u0011\t!!\"\u0002\t1\fgnZ\u0005\u0005\u0003\u0017\ty0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002>\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0007\u0005'\u0001B!a\u0010\u0003\u0010%!!\u0011CA\u0001\u0005\r\te.\u001f\u0005\n\u0005+!\u0015\u0011!a\u0001\u0003{\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u000e!\u0019\u0011iBa\t\u0003\u000e5\u0011!q\u0004\u0006\u0005\u0005C\t\t!\u0001\u0006d_2dWm\u0019;j_:LAA!\n\u0003 \tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tYNa\u000b\t\u0013\tUa)!AA\u0002\t5\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u000f\u0011\t\u0005u(1H\u0005\u0005\u0005{\tyP\u0001\u0004PE*,7\r^\u0001\u0007#V,W/\u001a3\u0011\u0007\u0005=8J\u0001\u0004Rk\u0016,X\rZ\n\n\u0017\u0006%\u0016QYA[\u0003w#\"A!\u0011\u0015\t\t5!1\n\u0005\n\u0005+\u0001\u0016\u0011!a\u0001\u0003{!B!a7\u0003P!I!Q\u0003*\u0002\u0002\u0003\u0007!QB\u0001\t\u0003\u000e\u001cW\r\u001d;fIB\u0019\u0011q^,\u0002\u0013\u00153g-Z2uSZ,\u0007cAAxG\nIQI\u001a4fGRLg/Z\n\nG\u0006%\u0016QYA[\u0003w#\"Aa\u0016\u0015\t\t5!\u0011\r\u0005\n\u0005+9\u0017\u0011!a\u0001\u0003{!B!a7\u0003f!I!QC5\u0002\u0002\u0003\u0007!QB\n\n/\u0006%\u0016QYA[\u0003w#\"Aa\u0015\u0015\t\t5!Q\u000e\u0005\n\u0005+a\u0016\u0011!a\u0001\u0003{!B!a7\u0003r!I!Q\u00030\u0002\u0002\u0003\u0007!QB\u0001\u0013e\u0016\f7o]5h]6,g\u000e^*uCR,\u0007%A\u0004u_BL7-\u00133\u0016\u0005\te\u0004CBA \u0005w\u0012y(\u0003\u0003\u0003~\u0005\u0005!AB(qi&|g\u000e\u0005\u0003\u0002\u0010\n\u0005\u0015\u0002\u0002BB\u0003#\u0013A!V;jI\u0006AAo\u001c9jG&#\u0007%\u0001\u0006dkJ\u0014XM\u001c;ESJ\f1bY;se\u0016tG\u000fR5sAQA!Q\u0012BH\u0005#\u0013\u0019\nE\u0002\u0002HvAq!!1%\u0001\u0004\t)\rC\u0004\u0003v\u0011\u0002\rA!\u001f\t\u000f\t\u001dE\u00051\u0001\u0003z\u0005qq/\u001b;i\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002BG\u00053CqAa'&\u0001\u0004\t)-A\foK^$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uK\u0006!1m\u001c9z)!\u0011iI!)\u0003$\n\u0015\u0006\"CAaMA\u0005\t\u0019AAc\u0011%\u0011)H\nI\u0001\u0002\u0004\u0011I\bC\u0005\u0003\b\u001a\u0002\n\u00111\u0001\u0003z\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BVU\u0011\t)M!,,\u0005\t=\u0006\u0003\u0002BY\u0005wk!Aa-\u000b\t\tU&qW\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!/\u0002\u0002\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu&1\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0007TCA!\u001f\u0003.\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aD\u0003\u0002B\u0007\u0005\u0013D\u0011B!\u0006-\u0003\u0003\u0005\r!!\u0010\u0015\t\u0005m'Q\u001a\u0005\n\u0005+q\u0013\u0011!a\u0001\u0005\u001b\ta!Z9vC2\u001cH\u0003BAn\u0005'D\u0011B!\u00062\u0003\u0003\u0005\rA!\u0004\u0002\u001dA\u0013x.\\8uS>t7\u000b^1uKB\u0019\u0011qY\u001a\u0014\u000bM\u0012Y.a/\u0011\u0019\tu'1]Ac\u0005s\u0012IH!$\u000e\u0005\t}'\u0002\u0002Bq\u0003\u0003\tqA];oi&lW-\u0003\u0003\u0003f\n}'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!q[\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005\u001b\u0013iOa<\u0003r\"9\u0011\u0011\u0019\u001cA\u0002\u0005\u0015\u0007b\u0002B;m\u0001\u0007!\u0011\u0010\u0005\b\u0005\u000f3\u0004\u0019\u0001B=\u0003\u001d)h.\u00199qYf$BAa>\u0003\u0000B1\u0011q\bB>\u0005s\u0004\"\"a\u0010\u0003|\u0006\u0015'\u0011\u0010B=\u0013\u0011\u0011i0!\u0001\u0003\rQ+\b\u000f\\34\u0011%\u0019\taNA\u0001\u0002\u0004\u0011i)A\u0002yIA\n\u0011CU3bgNLwM\\7f]R\u001cF/\u0019;f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u00111\u0011\u0002\u0016\u0005\u0003\u000f\u0012i+\u0001\tqe>lw\u000e^5p]N#\u0018\r^3tA\u0005YA.\u0019;fgR,\u0005o\\2i)\u0011\u0019\tba\u0005\u0011\r\u0005}\"1PA\u001f\u0011\u001d\u0019)\u0002\u0004a\u0001\u0003\u001b\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\t\rm1\u0011\u0005\t\u0005\u0003\u007f\u0019i\"\u0003\u0003\u0004 \u0005\u0005!\u0001\u0002'p]\u001eDqa!\u0006\u000e\u0001\u0004\ti)\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0004\u001c\r\u001d\u0002bBB\u000b\u001d\u0001\u0007\u0011QR\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBB\u0017\u0007k\u00199\u0004\u0005\u0004\u0002@\tm4q\u0006\t\u0005\u0003\u0013\u001a\t$\u0003\u0003\u00044\u0005-#AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\b\u0007+y\u0001\u0019AAG\u0011\u001d\u0019Id\u0004a\u0001\u0003{\tQ!\u001a9pG\"\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CB \u0007+\u001a9fa\u0017\u0011\r\u0005}\"1PB!!\u0011\u0019\u0019e!\u0015\u000e\u0005\r\u0015#\u0002BB$\u0007\u0013\n1\u0001\\8h\u0015\u0011\u0019Ye!\u0014\u0002\u0013%tG/\u001a:oC2\u001c(\u0002BB(\u0003#\nqa\u001d;pe\u0006<W-\u0003\u0003\u0004T\r\u0015#!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0004\u0016A\u0001\r!!$\t\u000f\re\u0003\u00031\u0001\u0004\u001c\u0005Ya-\u001a;dQ>3gm]3u\u0011\u001d\u0019i\u0006\u0005a\u0001\u0007?\nQ\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0003BB1\u0007Gj\u0011\u0001A\u0005\u0004\u0007K:(!\u0003$fi\u000eDG)\u0019;b\u0003A\u0011X-\\8wKB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004l\r]\u0004\u0003\u0003B\u000f\u0007[\nii!\u001d\n\t\r=$q\u0004\u0002\u0004\u001b\u0006\u0004\bc\u0001<\u0004t%\u00191QO8\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\re\u0014\u00031\u0001\u0004|\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003\u001e\ru\u0014QR\u0005\u0005\u0007\u007f\u0012yBA\u0002TKR$Baa!\u0004\u0006B\u0019\u0011\u0011T\u001d\t\u000f\rU!\u00031\u0001\u0002\u000e\u00069R\u000f\u001d3bi\u0016\u0014V-Y:tS\u001etW.\u001a8u'R\fG/\u001a\u000b\u0007\u0003#\u001cYi!$\t\u000f\rU1\u00031\u0001\u0002\u000e\"91qR\nA\u0002\r\r\u0015!B:uCR,\u0017!G7bs\n,\u0007K]8n_R,g)\u001e;ve\u0016\u0014V\r\u001d7jG\u0006$bA!\u0004\u0004\u0016\u000e]\u0005bBB\u000b)\u0001\u0007\u0011Q\u0012\u0005\b\u00073#\u0002\u0019ABN\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0004\u001e\u000e\rVBABP\u0015\r\u0019\t+]\u0001\bG2,8\u000f^3s\u0013\u0011\u0019)ka(\u0003\u0013A\u000b'\u000f^5uS>t\u0017!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004|\r-\u0006bBBW+\u0001\u00071qV\u0001\u0013S:LG/[1m\r\u0016$8\r[*uCR,7\u000f\u0005\u0005\u0003\u001e\r5\u0014QRBY!\r181W\u0005\u0004\u0007k{'!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0006y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0002A%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G\rI\u0001\tiJ,hnY1uKR1\u0011\u0011[B`\u0007\u0003Dqa!\u0006\u0019\u0001\u0004\ti\tC\u0004\u0004Db\u0001\ra!2\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042A^Bd\u0013\r\u0019Im\u001c\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000f\u0006\u0004\u0002R\u000e=7\u0011\u001b\u0005\b\u0007+I\u0002\u0019AAG\u0011\u001d\u0019\u0019.\u0007a\u0001\u00077\taa\u001c4gg\u0016$\b")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final DirectoryEventHandler directoryEventHandler;
    private final ConcurrentHashMap<TopicPartition, PromotionState> promotionStates;
    private final boolean isOffsetForLeaderEpochSupported;

    public static DirectoryEventHandler $lessinit$greater$default$8() {
        return ReplicaAlterLogDirsThread$.MODULE$.$lessinit$greater$default$8();
    }

    public ConcurrentHashMap<TopicPartition, PromotionState> promotionStates() {
        return this.promotionStates;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        DirectoryEventHandler directoryEventHandler = this.directoryEventHandler;
        DirectoryEventHandler directoryEventHandler2 = DirectoryEventHandler.NOOP;
        if (!(directoryEventHandler2 != null ? !directoryEventHandler2.equals(directoryEventHandler) : directoryEventHandler != null)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
        } else {
            this.maybePromoteFutureReplica(topicPartition, partition);
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Map<TopicPartition, PartitionFetchState> removePartitions(Set<TopicPartition> topicPartitions) {
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            if (this.promotionStates().containsKey(topicPartition)) {
                void var5_5;
                void var4_4;
                void var3_3;
                PromotionState promotionState = this.promotionStates().get(topicPartition);
                if (promotionState == null) {
                    throw new MatchError(null);
                }
                ReassignmentState reassignmentState = promotionState.reassignmentState();
                Option<Uuid> topicId = promotionState.topicId();
                Option<Uuid> originalDir = promotionState.currentDir();
                void reassignmentState2 = var3_3;
                void topicId2 = var4_4;
                void originalDir2 = var5_5;
                if (originalDir2.isDefined() && topicId2.isDefined() && reassignmentState2.maybeInconsistentMetadata()) {
                    $this.directoryEventHandler.handleAssignment(new TopicIdPartition((Uuid)topicId2.get(), topicPartition.partition()), (Uuid)originalDir2.get(), () -> {});
                }
                return this.promotionStates().remove(topicPartition);
            }
            return BoxedUnit.UNIT;
        });
        return super.removePartitions(topicPartitions);
    }

    private ReassignmentState reassignmentState(TopicPartition topicPartition) {
        return this.promotionStates().get(topicPartition).reassignmentState();
    }

    public void updateReassignmentState(TopicPartition topicPartition, ReassignmentState state) {
        this.log.debug(new StringBuilder(47).append("Updating future replica ").append(topicPartition).append(" reassignment state to ").append(state).toString());
        this.promotionStates().put(topicPartition, this.promotionStates().get(topicPartition).withAssignment(state));
    }

    private Object maybePromoteFutureReplica(TopicPartition topicPartition, Partition partition) {
        Option<Uuid> topicId = partition.topicId();
        if (topicId.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(27).append("Topic ").append(topicPartition.topic()).append(" does not have an ID.").toString());
        }
        ReassignmentState reassignmentState = this.reassignmentState(topicPartition);
        if (ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$.equals(reassignmentState)) {
            return BoxesRunTime.boxToBoolean((boolean)partition.runCallbackIfFutureReplicaCaughtUp((Function1<UnifiedLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
                ReplicaAlterLogDirsThread.$anonfun$maybePromoteFutureReplica$1(this, partition, topicId, topicPartition, x$2);
                return BoxedUnit.UNIT;
            }));
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$.equals(reassignmentState)) {
            if (partition.maybeReplaceCurrentWithFutureReplica()) {
                this.updateReassignmentState(topicPartition, ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$);
                return this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
            }
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$.equals(reassignmentState)) {
            this.log.trace("Waiting for AssignReplicasToDirsRequest to succeed before promoting the future replica.");
            return BoxedUnit.UNIT;
        }
        if (ReplicaAlterLogDirsThread$ReassignmentState$Effective$.MODULE$.equals(reassignmentState)) {
            throw new IllegalStateException("BUG: trying to promote a future replica twice");
        }
        throw new MatchError((Object)reassignmentState);
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            filteredFetchStates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    Option<Uuid> topicId = ((InitialFetchState)x0$2._2()).topicId();
                    Option<Uuid> currentDirectoryId = $this.replicaMgr.getPartitionOrException(topicPartition).logDirectoryId();
                    PromotionState promotionState = new PromotionState(ReplicaAlterLogDirsThread$ReassignmentState$None$.MODULE$, topicId, currentDirectoryId);
                    return this.promotionStates().put(topicPartition, promotionState);
                }
                throw new MatchError(null);
            });
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$maybePromoteFutureReplica$1(ReplicaAlterLogDirsThread $this, Partition partition$1, Option topicId$1, TopicPartition topicPartition$1, UnifiedLog x$2) {
        Uuid targetDir = (Uuid)partition$1.futureReplicaDirectoryId().get();
        TopicIdPartition topicIdPartition = new TopicIdPartition((Uuid)topicId$1.get(), topicPartition$1.partition());
        $this.directoryEventHandler.handleAssignment(topicIdPartition, targetDir, () -> $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Accepted$.MODULE$));
        $this.updateReassignmentState(topicPartition$1, ReplicaAlterLogDirsThread$ReassignmentState$Queued$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats, int fetchBackOffMs, DirectoryEventHandler directoryEventHandler) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.directoryEventHandler = directoryEventHandler;
        super(name, name, leader, failedPartitions, new ReplicaAlterLogDirsTierStateMachine(), fetchBackOffMs, false, brokerTopicStats);
        this.promotionStates = new ConcurrentHashMap();
        this.isOffsetForLeaderEpochSupported = true;
    }

    public static class PromotionState
    implements Product,
    scala.Serializable {
        private final ReassignmentState reassignmentState;
        private final Option<Uuid> topicId;
        private final Option<Uuid> currentDir;

        public ReassignmentState reassignmentState() {
            return this.reassignmentState;
        }

        public Option<Uuid> topicId() {
            return this.topicId;
        }

        public Option<Uuid> currentDir() {
            return this.currentDir;
        }

        public PromotionState withAssignment(ReassignmentState newDirReassignmentState) {
            return new PromotionState(newDirReassignmentState, this.topicId(), this.currentDir());
        }

        public PromotionState copy(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            return new PromotionState(reassignmentState, topicId, currentDir);
        }

        public ReassignmentState copy$default$1() {
            return this.reassignmentState();
        }

        public Option<Uuid> copy$default$2() {
            return this.topicId();
        }

        public Option<Uuid> copy$default$3() {
            return this.currentDir();
        }

        public String productPrefix() {
            return "PromotionState";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.reassignmentState();
                }
                case 1: {
                    return this.topicId();
                }
                case 2: {
                    return this.currentDir();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PromotionState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PromotionState)) break block3;
                    PromotionState promotionState = (PromotionState)x$1;
                    ReassignmentState reassignmentState = this.reassignmentState();
                    ReassignmentState reassignmentState2 = promotionState.reassignmentState();
                    if (reassignmentState != null ? !reassignmentState.equals(reassignmentState2) : reassignmentState2 != null) break block3;
                    Option<Uuid> option = this.topicId();
                    Option<Uuid> option2 = promotionState.topicId();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<Uuid> option3 = this.currentDir();
                    Option<Uuid> option4 = promotionState.currentDir();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !promotionState.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PromotionState(ReassignmentState reassignmentState, Option<Uuid> topicId, Option<Uuid> currentDir) {
            this.reassignmentState = reassignmentState;
            this.topicId = topicId;
            this.currentDir = currentDir;
            Product.$init$((Product)this);
        }
    }

    public static interface ReassignmentState {
        public static /* synthetic */ boolean maybeInconsistentMetadata$(ReassignmentState $this) {
            return $this.maybeInconsistentMetadata();
        }

        default public boolean maybeInconsistentMetadata() {
            return false;
        }

        public static void $init$(ReassignmentState $this) {
        }
    }
}

