/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.policy.AllConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.mirror.MirrorCheckpointConnector;
import org.apache.kafka.connect.mirror.MirrorHeartbeatConnector;
import org.apache.kafka.connect.mirror.MirrorHerder;
import org.apache.kafka.connect.mirror.MirrorMakerConfig;
import org.apache.kafka.connect.mirror.MirrorSourceConnector;
import org.apache.kafka.connect.mirror.SourceAndTarget;
import org.apache.kafka.connect.mirror.rest.MirrorRestServer;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.KafkaConfigBackingStore;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.apache.kafka.connect.storage.KafkaStatusBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.SharedTopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorMaker {
    private static final Logger log = LoggerFactory.getLogger(MirrorMaker.class);
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 60L;
    public static final List<Class<?>> CONNECTOR_CLASSES = Collections.unmodifiableList(Arrays.asList(MirrorSourceConnector.class, MirrorHeartbeatConnector.class, MirrorCheckpointConnector.class));
    private final Map<SourceAndTarget, Herder> herders = new HashMap<SourceAndTarget, Herder>();
    private CountDownLatch startLatch;
    private CountDownLatch stopLatch;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ShutdownHook shutdownHook;
    private final String advertisedUrl;
    private final Time time;
    private final MirrorMakerConfig config;
    private final Set<String> clusters;
    private final MirrorRestServer internalServer;
    private final RestClient restClient;

    public MirrorMaker(MirrorMakerConfig config, List<String> clusters, Time time) {
        log.debug("Kafka MirrorMaker instance created");
        this.time = time;
        if (config.enableInternalRest()) {
            this.restClient = new RestClient((AbstractConfig)config);
            this.internalServer = new MirrorRestServer(config.originals(), this.restClient);
            this.internalServer.initializeServer();
            this.advertisedUrl = this.internalServer.advertisedUrl().toString();
        } else {
            this.internalServer = null;
            this.restClient = null;
            this.advertisedUrl = "NOTUSED";
        }
        this.config = config;
        this.clusters = clusters != null && !clusters.isEmpty() ? new HashSet<String>(clusters) : config.clusters();
        log.info("Targeting clusters {}", this.clusters);
        Set<SourceAndTarget> herderPairs = config.clusterPairs().stream().filter(x -> this.clusters.contains(x.target())).collect(Collectors.toSet());
        if (herderPairs.isEmpty()) {
            throw new IllegalArgumentException("No source->target replication flows.");
        }
        herderPairs.forEach(this::addHerder);
        this.shutdownHook = new ShutdownHook();
    }

    public MirrorMaker(Map<String, String> config, List<String> clusters, Time time) {
        this(new MirrorMakerConfig(config), clusters, time);
    }

    public MirrorMaker(Map<String, String> props, List<String> clusters) {
        this(props, clusters, Time.SYSTEM);
    }

    public MirrorMaker(Map<String, String> props) {
        this(props, null);
    }

    public void start() {
        log.info("Kafka MirrorMaker starting with {} herders.", (Object)this.herders.size());
        if (this.startLatch != null) {
            throw new IllegalStateException("MirrorMaker instance already started");
        }
        this.startLatch = new CountDownLatch(this.herders.size());
        this.stopLatch = new CountDownLatch(this.herders.size());
        Exit.addShutdownHook((String)"mirror-maker-shutdown-hook", (Runnable)this.shutdownHook);
        for (Herder herder : this.herders.values()) {
            try {
                herder.start();
            }
            finally {
                this.startLatch.countDown();
            }
        }
        if (this.internalServer != null) {
            log.info("Initializing internal REST resources");
            this.internalServer.initializeInternalResources(this.herders);
        }
        log.info("Configuring connectors will happen once the worker joins the group as a leader");
        log.info("Kafka MirrorMaker started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        boolean wasShuttingDown = this.shutdown.getAndSet(true);
        if (!wasShuttingDown) {
            log.info("Kafka MirrorMaker stopping");
            if (this.internalServer != null) {
                Utils.closeQuietly(() -> ((MirrorRestServer)this.internalServer).stop(), (String)"Internal REST server");
            }
            for (Herder herder : this.herders.values()) {
                try {
                    herder.stop();
                }
                finally {
                    this.stopLatch.countDown();
                }
            }
            log.info("Kafka MirrorMaker stopped.");
        }
    }

    public void awaitStop() {
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException e) {
            log.error("Interrupted waiting for MirrorMaker to shutdown");
        }
    }

    private void checkHerder(SourceAndTarget sourceAndTarget) {
        if (!this.herders.containsKey(sourceAndTarget)) {
            throw new IllegalArgumentException("No herder for " + sourceAndTarget.toString());
        }
    }

    private void addHerder(SourceAndTarget sourceAndTarget) {
        List<String> restNamespace;
        log.info("creating herder for " + sourceAndTarget.toString());
        Map<String, String> workerProps = this.config.workerConfig(sourceAndTarget);
        try {
            String encodedSource = MirrorMaker.encodePath(sourceAndTarget.source());
            String encodedTarget = MirrorMaker.encodePath(sourceAndTarget.target());
            restNamespace = Arrays.asList(encodedSource, encodedTarget);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to create encoded URL paths for source and target using UTF-8", e);
        }
        String workerId = sourceAndTarget.toString();
        Plugins plugins = new Plugins(workerProps);
        plugins.compareAndSwapWithDelegatingLoader();
        DistributedConfig distributedConfig = new DistributedConfig(workerProps);
        String kafkaClusterId = distributedConfig.kafkaClusterId();
        String clientIdBase = ConnectUtils.clientIdBase((WorkerConfig)distributedConfig);
        HashMap<String, String> adminProps = new HashMap<String, String>(distributedConfig.originals());
        adminProps.put("client.id", clientIdBase + "shared-admin");
        ConnectUtils.addMetricsContextProperties(adminProps, (WorkerConfig)distributedConfig, (String)kafkaClusterId);
        SharedTopicAdmin sharedAdmin = new SharedTopicAdmin(adminProps);
        KafkaOffsetBackingStore offsetBackingStore = new KafkaOffsetBackingStore((Supplier)sharedAdmin, () -> clientIdBase, plugins.newInternalConverter(true, JsonConverter.class.getName(), Collections.singletonMap("schemas.enable", "false")));
        offsetBackingStore.configure((WorkerConfig)distributedConfig);
        AllConnectorClientConfigOverridePolicy clientConfigOverridePolicy = new AllConnectorClientConfigOverridePolicy();
        clientConfigOverridePolicy.configure(this.config.originals());
        Worker worker = new Worker(workerId, this.time, plugins, (WorkerConfig)distributedConfig, (OffsetBackingStore)offsetBackingStore, (ConnectorClientConfigOverridePolicy)clientConfigOverridePolicy);
        WorkerConfigTransformer configTransformer = worker.configTransformer();
        Converter internalValueConverter = worker.getInternalValueConverter();
        KafkaStatusBackingStore statusBackingStore = new KafkaStatusBackingStore(this.time, internalValueConverter, (Supplier)sharedAdmin, clientIdBase);
        statusBackingStore.configure((WorkerConfig)distributedConfig);
        KafkaConfigBackingStore configBackingStore = new KafkaConfigBackingStore(internalValueConverter, distributedConfig, configTransformer, (Supplier)sharedAdmin, clientIdBase);
        MirrorHerder herder = new MirrorHerder(this.config, sourceAndTarget, distributedConfig, this.time, worker, kafkaClusterId, (StatusBackingStore)statusBackingStore, (ConfigBackingStore)configBackingStore, this.advertisedUrl, this.restClient, (ConnectorClientConfigOverridePolicy)clientConfigOverridePolicy, restNamespace, new AutoCloseable[]{sharedAdmin});
        this.herders.put(sourceAndTarget, (Herder)herder);
    }

    private static String encodePath(String rawPath) throws UnsupportedEncodingException {
        return URLEncoder.encode(rawPath, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
    }

    public ConnectorStateInfo connectorStatus(SourceAndTarget sourceAndTarget, String connector) {
        this.checkHerder(sourceAndTarget);
        return this.herders.get(sourceAndTarget).connectorStatus(connector);
    }

    public void taskConfigs(SourceAndTarget sourceAndTarget, String connector, Callback<List<TaskInfo>> cb) {
        this.checkHerder(sourceAndTarget);
        this.herders.get(sourceAndTarget).taskConfigs(connector, cb);
    }

    public static void main(String[] args) {
        Namespace ns;
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"connect-mirror-maker");
        parser.description("MirrorMaker 2.0 driver");
        parser.addArgument(new String[]{"config"}).type((ArgumentType)Arguments.fileType().verifyCanRead()).metavar(new String[]{"mm2.properties"}).required(true).help("MM2 configuration file.");
        parser.addArgument(new String[]{"--clusters"}).nargs("+").metavar(new String[]{"CLUSTER"}).required(false).help("Target cluster to use for this node.");
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            Exit.exit((int)-1);
            return;
        }
        File configFile = (File)ns.get("config");
        List clusters = ns.getList("clusters");
        try {
            log.info("Kafka MirrorMaker initializing ...");
            Properties props = Utils.loadProps((String)configFile.getPath());
            Map config = Utils.propsToStringMap((Properties)props);
            MirrorMaker mirrorMaker = new MirrorMaker(config, clusters);
            try {
                mirrorMaker.start();
            }
            catch (Exception e) {
                log.error("Failed to start MirrorMaker", (Throwable)e);
                mirrorMaker.stop();
                Exit.exit((int)3);
            }
            mirrorMaker.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit((int)2);
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (!MirrorMaker.this.startLatch.await(60L, TimeUnit.SECONDS)) {
                    log.error("Timed out in shutdown hook waiting for MirrorMaker startup to finish. Unable to shutdown cleanly.");
                }
            }
            catch (InterruptedException e) {
                log.error("Interrupted in shutdown hook while waiting for MirrorMaker startup to finish. Unable to shutdown cleanly.");
            }
            finally {
                MirrorMaker.this.stop();
            }
        }
    }
}

