/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;

public class ExplainingMatch
extends QueryMatch {
    public static final MatcherFactory<ExplainingMatch> MATCHER = searcher -> new CandidateMatcher<ExplainingMatch>(searcher){

        @Override
        protected void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) throws IOException {
            int maxDocs = this.searcher.getIndexReader().maxDoc();
            for (int i = 0; i < maxDocs; ++i) {
                Explanation explanation = this.searcher.explain(matchQuery, i);
                if (!explanation.isMatch()) continue;
                this.addMatch(new ExplainingMatch(queryId, explanation), i);
            }
        }

        @Override
        public ExplainingMatch resolve(ExplainingMatch match1, ExplainingMatch match2) {
            return new ExplainingMatch(match1.getQueryId(), Explanation.match((Number)(match1.getExplanation().getValue().doubleValue() + match2.getExplanation().getValue().doubleValue()), (String)"sum of:", (Explanation[])new Explanation[]{match1.getExplanation(), match2.getExplanation()}));
        }
    };
    private final Explanation explanation;

    ExplainingMatch(String queryId, Explanation explanation) {
        super(queryId);
        this.explanation = explanation;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExplainingMatch that = (ExplainingMatch)o;
        return Objects.equals(this.explanation, that.explanation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.explanation);
    }
}

