/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit.sharedterms;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockReader;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.sharedterms.STBlockLine;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

public class STBlockReader
extends BlockReader {
    protected final FieldInfos fieldInfos;

    public STBlockReader(IndexDictionary.BrowserSupplier dictionaryBrowserSupplier, IndexInput blockInput, PostingsReaderBase postingsReader, FieldMetadata fieldMetadata, BlockDecoder blockDecoder, FieldInfos fieldInfos) throws IOException {
        super(dictionaryBrowserSupplier, blockInput, postingsReader, fieldMetadata, blockDecoder);
        this.fieldInfos = fieldInfos;
    }

    @Override
    public BytesRef next() throws IOException {
        BytesRef next;
        do {
            if ((next = super.next()) != null) continue;
            return null;
        } while (!this.termOccursInField());
        return next;
    }

    private boolean termOccursInField() throws IOException {
        this.readTermStateIfNotRead();
        return this.termState != null;
    }

    @Override
    protected BytesRef nextTerm() throws IOException {
        BytesRef nextTerm = super.nextTerm();
        if (nextTerm != null && super.isBeyondLastTerm(nextTerm, this.blockStartFP)) {
            return null;
        }
        return nextTerm;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef searchedTerm) throws IOException {
        TermsEnum.SeekStatus seekStatus = this.seekCeilIgnoreField(searchedTerm);
        if (seekStatus != TermsEnum.SeekStatus.END && !this.termOccursInField()) {
            BytesRef nextTerm = this.next();
            seekStatus = nextTerm == null ? TermsEnum.SeekStatus.END : TermsEnum.SeekStatus.NOT_FOUND;
        }
        return seekStatus;
    }

    TermsEnum.SeekStatus seekCeilIgnoreField(BytesRef searchedTerm) throws IOException {
        return super.seekCeil(searchedTerm);
    }

    @Override
    public boolean seekExact(BytesRef searchedTerm) throws IOException {
        if (super.seekExact(searchedTerm)) {
            return this.termOccursInField();
        }
        return false;
    }

    @Override
    protected boolean isBeyondLastTerm(BytesRef searchedTerm, long blockStartFP) {
        return blockStartFP > this.fieldMetadata.getLastBlockStartFP() || super.isBeyondLastTerm(searchedTerm, blockStartFP);
    }

    @Override
    protected STBlockLine.Serializer createBlockLineSerializer() {
        return new STBlockLine.Serializer();
    }

    @Override
    protected BlockTermState readTermState() throws IOException {
        this.termStatesReadBuffer.setPosition(this.blockFirstLineStart + this.blockHeader.getTermStatesBaseOffset() + this.blockLine.getTermStateRelativeOffset());
        this.termState = ((STBlockLine.Serializer)this.blockLineReader).readTermStateForField(this.fieldMetadata.getFieldInfo().number, (DataInput)this.termStatesReadBuffer, this.termStateSerializer, this.blockHeader, this.fieldInfos, this.scratchTermState);
        return this.termState;
    }
}

