/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.HashMap;
import javax.measure.converter.AddConverter;
import javax.measure.converter.ConversionException;
import javax.measure.converter.LinearConverter;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Dimension;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.UnitFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Unit<Q extends Quantity>
implements Serializable {
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    static final HashMap<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();
    private static final long serialVersionUID = 1L;

    Unit() {
    }

    public abstract Unit<Q> toSI();

    public abstract UnitConverter getConverterToSI();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public boolean isSI() {
        return this.toSI().equals(this);
    }

    public final boolean isCompatible(Unit<?> that) {
        return this == that || this.toSI().equals(that.toSI()) || this.getDimension().equals(that.getDimension());
    }

    public final <T extends Quantity> Unit<T> asType(Class<T> type) throws ClassCastException {
        Dimension thisDimension = this.getDimension();
        Unit quantityUnit = null;
        try {
            quantityUnit = (Unit)type.getField("UNIT").get(null);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("The quantity class " + type + " does not have a public static field UNIT holding the SI unit " + " for the quantity.");
        }
        Dimension quantityDimension = quantityUnit.getDimension();
        if (!thisDimension.equals(quantityDimension)) {
            throw new ClassCastException("Dimension of " + this + " is " + thisDimension + ", but the dimension of quantity of type " + type.getName() + " is " + quantityDimension);
        }
        return this;
    }

    public final Dimension getDimension() {
        Unit<Q> systemUnit = this.toSI();
        if (systemUnit instanceof BaseUnit) {
            return Dimension.Model.STANDARD.getDimension((BaseUnit)systemUnit);
        }
        if (systemUnit instanceof AlternateUnit) {
            return ((AlternateUnit)systemUnit).getParent().getDimension();
        }
        ProductUnit productUnit = (ProductUnit)systemUnit;
        Dimension dimension = Dimension.NONE;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            Dimension d = unit.getDimension().pow(productUnit.getUnitPow(i)).root(productUnit.getUnitRoot(i));
            dimension = dimension.times(d);
        }
        return dimension;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws UnsupportedOperationException {
        try {
            return this.getConverterToAny(that);
        }
        catch (ConversionException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public final UnitConverter getConverterToAny(Unit<?> that) throws ConversionException, UnsupportedOperationException {
        return this == that || this.equals(that) ? UnitConverter.IDENTITY : this.searchConverterTo(that);
    }

    private UnitConverter searchConverterTo(Unit<?> that) throws ConversionException {
        Unit<?> thatSI;
        Unit<Q> thisSI = this.toSI();
        if (thisSI.equals(thatSI = that.toSI())) {
            return that.getConverterToSI().inverse().concatenate(this.getConverterToSI());
        }
        if (!thisSI.getDimension().equals(thatSI.getDimension())) {
            throw new ConversionException(this + " is not compatible with " + that);
        }
        UnitConverter thisTransform = this.getConverterToSI().concatenate(Unit.transformOf(this.toBaseUnits()));
        UnitConverter thatTransform = that.getConverterToSI().concatenate(Unit.transformOf(super.toBaseUnits()));
        return thatTransform.inverse().concatenate(thisTransform);
    }

    private Unit<?> toBaseUnits() {
        Unit<Q> systemUnit = this.toSI();
        if (systemUnit instanceof BaseUnit) {
            return systemUnit;
        }
        if (systemUnit instanceof AlternateUnit) {
            return super.toBaseUnits();
        }
        if (systemUnit instanceof ProductUnit) {
            ProductUnit productUnit = (ProductUnit)systemUnit;
            Unit<Dimensionless> baseUnits = ONE;
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                Unit<?> unit = super.toBaseUnits();
                unit = unit.pow(productUnit.getUnitPow(i));
                unit = unit.root(productUnit.getUnitRoot(i));
                baseUnits = baseUnits.times(unit);
            }
            return baseUnits;
        }
        throw new UnsupportedOperationException("System Unit cannot be an instance of " + this.getClass());
    }

    private static UnitConverter transformOf(Unit<?> baseUnits) throws UnsupportedOperationException {
        if (baseUnits instanceof BaseUnit) {
            return Dimension.Model.STANDARD.getTransform((BaseUnit)baseUnits);
        }
        ProductUnit productUnit = (ProductUnit)baseUnits;
        UnitConverter converter = UnitConverter.IDENTITY;
        for (int i = 0; i < productUnit.getUnitCount(); ++i) {
            Unit<Quantity> unit = productUnit.getUnit(i);
            UnitConverter cvtr = Unit.transformOf(unit);
            if (!(cvtr instanceof LinearConverter)) {
                throw new UnsupportedOperationException(baseUnits + " is non-linear, cannot convert");
            }
            if (productUnit.getUnitRoot(i) != 1) {
                throw new UnsupportedOperationException(productUnit + " holds a base unit with fractional exponent");
            }
            int pow = productUnit.getUnitPow(i);
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    public final <A extends Quantity> AlternateUnit<A> alternate(String symbol) {
        return new AlternateUnit(symbol, this);
    }

    public final CompoundUnit<Q> compound(Unit<Q> that) {
        return new CompoundUnit<Q>(this, that);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        if (this instanceof TransformedUnit) {
            TransformedUnit tf = (TransformedUnit)this;
            Unit parent = tf.getParentUnit();
            UnitConverter toParent = tf.toParentUnit().concatenate(operation);
            if (toParent == UnitConverter.IDENTITY) {
                return parent;
            }
            return new TransformedUnit(parent, toParent);
        }
        if (operation == UnitConverter.IDENTITY) {
            return this;
        }
        return new TransformedUnit(this, operation);
    }

    public final Unit<Q> plus(double offset) {
        if (offset == 0.0) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    public final Unit<Q> times(long factor) {
        if (factor == 1L) {
            return this;
        }
        return this.transform(new RationalConverter(BigInteger.valueOf(factor), BigInteger.ONE));
    }

    public final Unit<Q> times(double factor) {
        if (factor == 1.0) {
            return this;
        }
        return this.transform(new MultiplyConverter(factor));
    }

    public final Unit<?> times(Unit<?> that) {
        if (this.equals(ONE)) {
            return that;
        }
        if (that.equals(ONE)) {
            return this;
        }
        if (this.isRationalFactor()) {
            return that.transform(this.getConverterTo(ONE));
        }
        if (super.isRationalFactor()) {
            return this.transform(that.getConverterTo(ONE));
        }
        return ProductUnit.getProductInstance(this, that);
    }

    private boolean isRationalFactor() {
        if (!(this instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit tu = (TransformedUnit)this;
        return tu.getParentUnit().equals(ONE) && tu.getConverterTo(tu.toSI()) instanceof RationalConverter;
    }

    public final Unit<?> inverse() {
        if (this.equals(ONE)) {
            return this;
        }
        if (this.isRationalFactor()) {
            return this.transform(this.getConverterTo(ONE).inverse());
        }
        return ProductUnit.getQuotientInstance(ONE, this);
    }

    public final Unit<Q> divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.transform(new RationalConverter(BigInteger.ONE, BigInteger.valueOf(divisor)));
    }

    public final Unit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final Unit<?> divide(Unit<?> that) {
        return this.times(that.inverse());
    }

    public final Unit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<?> pow(int n) {
        if (n > 0) {
            return this.times(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit<?> valueOf(CharSequence csq) {
        return UnitFormat.getStandard().parse(csq, new ParsePosition(0));
    }

    public String toString() {
        return UnitFormat.getStandard().format(this);
    }
}

