/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.compat.interactivity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.PrompterException;
import org.apache.maven.jline.DefaultPrompter;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.eclipse.sisu.Priority;

@Named
@Singleton
@Priority(value=10)
@Experimental
public class LegacyPlexusInteractivity
implements Prompter,
InputHandler,
OutputHandler {
    private final DefaultPrompter defaultPrompter;

    @Inject
    public LegacyPlexusInteractivity(DefaultPrompter defaultPrompter) {
        this.defaultPrompter = defaultPrompter;
    }

    public String readLine() throws IOException {
        return this.defaultPrompter.doPrompt(null, false);
    }

    public String readPassword() throws IOException {
        return this.defaultPrompter.doPrompt(null, true);
    }

    public List<String> readMultipleLines() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = this.readLine();
        while (line != null && !line.isEmpty()) {
            lines.add(line);
            line = this.readLine();
        }
        return lines;
    }

    public void write(String line) throws IOException {
        this.defaultPrompter.doDisplay(line);
    }

    public void writeLine(String line) throws IOException {
        this.defaultPrompter.doDisplay(line + System.lineSeparator());
    }

    public String prompt(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.defaultPrompter.prompt(message, null, null);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, String defaultReply) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.defaultPrompter.prompt(message, null, defaultReply);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.defaultPrompter.prompt(message, possibleValues, null);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.defaultPrompter.prompt(message, possibleValues, defaultReply);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String promptForPassword(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.defaultPrompter.promptForPassword(message);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to promptForPassword", (Throwable)e);
        }
    }

    public void showMessage(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            this.defaultPrompter.showMessage(message);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to showMessage", (Throwable)e);
        }
    }
}

