/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import java.util.Map;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.EnforcePolicyPermissionsThroughBaseResource;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;

public class AccessPolicyAuthorizable
implements Authorizable,
EnforcePolicyPermissionsThroughBaseResource {
    private static final Authorizable POLICIES_AUTHORIZABLE = new Authorizable(){

        public Authorizable getParentAuthorizable() {
            return null;
        }

        public Resource getResource() {
            return ResourceFactory.getPoliciesResource();
        }
    };
    final Authorizable authorizable;

    public AccessPolicyAuthorizable(Authorizable authorizable) {
        this.authorizable = authorizable;
    }

    @Override
    public Authorizable getBaseAuthorizable() {
        return this.authorizable;
    }

    public Authorizable getParentAuthorizable() {
        Authorizable effectiveAuthorizable = this.getEffectiveAuthorizable();
        if (effectiveAuthorizable.getParentAuthorizable() == null) {
            return POLICIES_AUTHORIZABLE;
        }
        return new AccessPolicyAuthorizable(effectiveAuthorizable.getParentAuthorizable());
    }

    public Resource getResource() {
        return ResourceFactory.getPolicyResource(this.getEffectiveAuthorizable().getResource());
    }

    private Authorizable getEffectiveAuthorizable() {
        if (this.authorizable instanceof EnforcePolicyPermissionsThroughBaseResource) {
            Authorizable baseAuthorizable = ((EnforcePolicyPermissionsThroughBaseResource)this.authorizable).getBaseAuthorizable();
            if (baseAuthorizable instanceof AccessPolicyAuthorizable) {
                return this.authorizable;
            }
            return baseAuthorizable;
        }
        return this.authorizable;
    }

    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        AuthorizationResult resourceResult = super.checkAuthorization(authorizer, action, user, resourceContext);
        if (AuthorizationResult.Result.Denied.equals((Object)resourceResult.getResult())) {
            return this.getParentAuthorizable().checkAuthorization(authorizer, action, user, resourceContext);
        }
        return resourceResult;
    }

    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        try {
            super.authorize(authorizer, action, user, resourceContext);
        }
        catch (AccessDeniedException resourceDenied) {
            try {
                this.getParentAuthorizable().authorize(authorizer, action, user, resourceContext);
            }
            catch (AccessDeniedException policiesDenied) {
                throw resourceDenied;
            }
        }
    }
}

