/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.database;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.util.UserGroupProviderUtils;

public class DatabaseUserGroupHolder {
    private final Set<User> allUsers;
    private final Map<String, User> usersById;
    private final Map<String, User> usersByIdentity;
    private final Set<Group> allGroups;
    private final Map<String, Group> groupsById;
    private final Map<String, Set<Group>> groupsByUserIdentity;

    public DatabaseUserGroupHolder(Set<User> allUsers, Set<Group> allGroups) {
        this.allUsers = allUsers;
        this.allGroups = allGroups;
        this.usersById = Collections.unmodifiableMap(UserGroupProviderUtils.createUserByIdMap(allUsers));
        this.usersByIdentity = Collections.unmodifiableMap(UserGroupProviderUtils.createUserByIdentityMap(allUsers));
        this.groupsById = Collections.unmodifiableMap(UserGroupProviderUtils.createGroupByIdMap(allGroups));
        this.groupsByUserIdentity = Collections.unmodifiableMap(UserGroupProviderUtils.createGroupsByUserIdentityMap(allGroups, allUsers));
    }

    public Set<User> getAllUsers() {
        return this.allUsers;
    }

    public Map<String, User> getUsersById() {
        return this.usersById;
    }

    public Map<String, User> getUsersByIdentity() {
        return this.usersByIdentity;
    }

    public Set<Group> getAllGroups() {
        return this.allGroups;
    }

    public Map<String, Group> getGroupsById() {
        return this.groupsById;
    }

    public User getUser(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        return this.usersByIdentity.get(identity);
    }

    public Set<Group> getGroups(String userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("User Identity cannot be null");
        }
        return this.groupsByUserIdentity.get(userIdentity);
    }
}

