/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.util;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExchangeUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpExchangeUtils.class);

    public static void drainRequestBody(HttpExchange exchange) {
        byte[] buffer = new byte[4096];
        try (InputStream in = exchange.getRequestBody();){
            while (in.read(buffer) != -1) {
            }
        }
        catch (IOException ioe) {
            logger.debug("Failed to fully drain HttpExchange InputStream from {}", (Object)exchange.getRequestURI(), (Object)ioe);
        }
    }
}

