/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAccessEventTag is the corresponding interface of BACnetConstructedDataAccessEventTag
type BACnetConstructedDataAccessEventTag interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAccessEventTag returns AccessEventTag (property field)
	GetAccessEventTag() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataAccessEventTag is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAccessEventTag()
	// CreateBuilder creates a BACnetConstructedDataAccessEventTagBuilder
	CreateBACnetConstructedDataAccessEventTagBuilder() BACnetConstructedDataAccessEventTagBuilder
}

// _BACnetConstructedDataAccessEventTag is the data-structure of this message
type _BACnetConstructedDataAccessEventTag struct {
	BACnetConstructedDataContract
	AccessEventTag BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataAccessEventTag = (*_BACnetConstructedDataAccessEventTag)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAccessEventTag)(nil)

// NewBACnetConstructedDataAccessEventTag factory function for _BACnetConstructedDataAccessEventTag
func NewBACnetConstructedDataAccessEventTag(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, accessEventTag BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAccessEventTag {
	if accessEventTag == nil {
		panic("accessEventTag of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataAccessEventTag must not be nil")
	}
	_result := &_BACnetConstructedDataAccessEventTag{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AccessEventTag:                accessEventTag,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAccessEventTagBuilder is a builder for BACnetConstructedDataAccessEventTag
type BACnetConstructedDataAccessEventTagBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accessEventTag BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAccessEventTagBuilder
	// WithAccessEventTag adds AccessEventTag (property field)
	WithAccessEventTag(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAccessEventTagBuilder
	// WithAccessEventTagBuilder adds AccessEventTag (property field) which is build by the builder
	WithAccessEventTagBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAccessEventTagBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAccessEventTag or returns an error if something is wrong
	Build() (BACnetConstructedDataAccessEventTag, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAccessEventTag
}

// NewBACnetConstructedDataAccessEventTagBuilder() creates a BACnetConstructedDataAccessEventTagBuilder
func NewBACnetConstructedDataAccessEventTagBuilder() BACnetConstructedDataAccessEventTagBuilder {
	return &_BACnetConstructedDataAccessEventTagBuilder{_BACnetConstructedDataAccessEventTag: new(_BACnetConstructedDataAccessEventTag)}
}

type _BACnetConstructedDataAccessEventTagBuilder struct {
	*_BACnetConstructedDataAccessEventTag

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAccessEventTagBuilder) = (*_BACnetConstructedDataAccessEventTagBuilder)(nil)

func (b *_BACnetConstructedDataAccessEventTagBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAccessEventTag
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) WithMandatoryFields(accessEventTag BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAccessEventTagBuilder {
	return b.WithAccessEventTag(accessEventTag)
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) WithAccessEventTag(accessEventTag BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAccessEventTagBuilder {
	b.AccessEventTag = accessEventTag
	return b
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) WithAccessEventTagBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAccessEventTagBuilder {
	builder := builderSupplier(b.AccessEventTag.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.AccessEventTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) Build() (BACnetConstructedDataAccessEventTag, error) {
	if b.AccessEventTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'accessEventTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAccessEventTag.deepCopy(), nil
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) MustBuild() BACnetConstructedDataAccessEventTag {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAccessEventTagBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAccessEventTagBuilder().(*_BACnetConstructedDataAccessEventTagBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAccessEventTagBuilder creates a BACnetConstructedDataAccessEventTagBuilder
func (b *_BACnetConstructedDataAccessEventTag) CreateBACnetConstructedDataAccessEventTagBuilder() BACnetConstructedDataAccessEventTagBuilder {
	if b == nil {
		return NewBACnetConstructedDataAccessEventTagBuilder()
	}
	return &_BACnetConstructedDataAccessEventTagBuilder{_BACnetConstructedDataAccessEventTag: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAccessEventTag) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAccessEventTag) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACCESS_EVENT_TAG
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAccessEventTag) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAccessEventTag) GetAccessEventTag() BACnetApplicationTagUnsignedInteger {
	return m.AccessEventTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAccessEventTag) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetAccessEventTag())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAccessEventTag(structType any) BACnetConstructedDataAccessEventTag {
	if casted, ok := structType.(BACnetConstructedDataAccessEventTag); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAccessEventTag); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAccessEventTag) GetTypeName() string {
	return "BACnetConstructedDataAccessEventTag"
}

func (m *_BACnetConstructedDataAccessEventTag) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (accessEventTag)
	lengthInBits += m.AccessEventTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAccessEventTag) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAccessEventTag) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAccessEventTag BACnetConstructedDataAccessEventTag, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAccessEventTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAccessEventTag")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accessEventTag, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "accessEventTag", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEventTag' field"))
	}
	m.AccessEventTag = accessEventTag

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), accessEventTag)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAccessEventTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAccessEventTag")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAccessEventTag) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAccessEventTag) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAccessEventTag"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAccessEventTag")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "accessEventTag", m.GetAccessEventTag(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEventTag' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAccessEventTag"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAccessEventTag")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAccessEventTag) IsBACnetConstructedDataAccessEventTag() {}

func (m *_BACnetConstructedDataAccessEventTag) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAccessEventTag) deepCopy() *_BACnetConstructedDataAccessEventTag {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAccessEventTagCopy := &_BACnetConstructedDataAccessEventTag{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.AccessEventTag),
	}
	_BACnetConstructedDataAccessEventTagCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAccessEventTagCopy
}

func (m *_BACnetConstructedDataAccessEventTag) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
