/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import jakarta.jms.JMSRuntimeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.meta.JmsConsumerInfo;

public class AmqpSubscriptionTracker {
    Set<String> exclusiveDurableSubs = new HashSet<String>();
    Map<String, SubDetails> sharedDurableSubs = new HashMap<String, SubDetails>();
    Map<String, SubDetails> sharedVolatileSubs = new HashMap<String, SubDetails>();

    public String reserveNextSubscriptionLinkName(String subscriptionName, JmsConsumerInfo consumerInfo) {
        this.validateSubscriptionName(subscriptionName);
        if (consumerInfo == null) {
            throw new IllegalArgumentException("Consumer info must not be null.");
        }
        if (consumerInfo.isShared()) {
            if (consumerInfo.isDurable()) {
                return this.getSharedDurableSubLinkName(subscriptionName, consumerInfo);
            }
            return this.getSharedVolatileSubLinkName(subscriptionName, consumerInfo);
        }
        if (consumerInfo.isDurable()) {
            this.registerExclusiveDurableSub(subscriptionName);
            return subscriptionName;
        }
        throw new IllegalStateException("Non-shared non-durable sub link naming is not handled by the tracker.");
    }

    private void validateSubscriptionName(String subscriptionName) {
        if (subscriptionName == null) {
            throw new IllegalArgumentException("Subscription name must not be null.");
        }
        if (subscriptionName.isEmpty()) {
            throw new IllegalArgumentException("Subscription name must not be empty.");
        }
        if (subscriptionName.contains("|")) {
            throw new IllegalArgumentException("Subscription name must not contain '|' character.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSharedDurableSubLinkName(String subscriptionName, JmsConsumerInfo consumerInfo) {
        JmsDestination topic = consumerInfo.getDestination();
        String selector = consumerInfo.getSelector();
        SubDetails subDetails = null;
        if (this.sharedDurableSubs.containsKey(subscriptionName)) {
            subDetails = this.sharedDurableSubs.get(subscriptionName);
            if (!subDetails.matches(topic, selector)) throw new JMSRuntimeException("Subscription details dont match existing subscriber.");
            subDetails.addSubscriber(consumerInfo);
        } else {
            subDetails = new SubDetails(topic, selector, consumerInfo);
        }
        this.sharedDurableSubs.put(subscriptionName, subDetails);
        int count = subDetails.totalSubscriberCount();
        return this.getDurableSubscriptionLinkName(subscriptionName, consumerInfo.isExplicitClientID(), count);
    }

    private String getDurableSubscriptionLinkName(String subscriptionName, boolean hasClientID, int count) {
        Object linkName = this.getFirstDurableSubscriptionLinkName(subscriptionName, hasClientID);
        if (count > 1) {
            linkName = hasClientID ? (String)linkName + "|" + count : (String)linkName + count;
        }
        return linkName;
    }

    public String getFirstDurableSubscriptionLinkName(String subscriptionName, boolean hasClientID) {
        this.validateSubscriptionName(subscriptionName);
        Object receiverLinkName = subscriptionName;
        if (!hasClientID) {
            receiverLinkName = (String)receiverLinkName + "|global";
        }
        return receiverLinkName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSharedVolatileSubLinkName(String subscriptionName, JmsConsumerInfo consumerInfo) {
        JmsDestination topic = consumerInfo.getDestination();
        String selector = consumerInfo.getSelector();
        SubDetails subDetails = null;
        if (this.sharedVolatileSubs.containsKey(subscriptionName)) {
            subDetails = this.sharedVolatileSubs.get(subscriptionName);
            if (!subDetails.matches(topic, selector)) throw new JMSRuntimeException("Subscription details dont match existing subscriber");
            subDetails.addSubscriber(consumerInfo);
        } else {
            subDetails = new SubDetails(topic, selector, consumerInfo);
        }
        this.sharedVolatileSubs.put(subscriptionName, subDetails);
        String receiverLinkName = subscriptionName + "|";
        int count = subDetails.totalSubscriberCount();
        if (!consumerInfo.isExplicitClientID()) return receiverLinkName + "global-volatile" + count;
        return receiverLinkName + "volatile" + count;
    }

    private void registerExclusiveDurableSub(String subscriptionName) {
        this.exclusiveDurableSubs.add(subscriptionName);
    }

    public boolean isActiveExclusiveDurableSub(String subscriptionName) {
        return this.exclusiveDurableSubs.contains(subscriptionName);
    }

    public boolean isActiveSharedDurableSub(String subscriptionName) {
        return this.sharedDurableSubs.containsKey(subscriptionName);
    }

    public boolean isActiveDurableSub(String subscriptionName) {
        return this.isActiveExclusiveDurableSub(subscriptionName) || this.isActiveSharedDurableSub(subscriptionName);
    }

    public boolean isActiveSharedVolatileSub(String subscriptionName) {
        return this.sharedVolatileSubs.containsKey(subscriptionName);
    }

    public void consumerRemoved(JmsConsumerInfo consumerInfo) {
        String subscriptionName = consumerInfo.getSubscriptionName();
        if (subscriptionName != null && !subscriptionName.isEmpty()) {
            if (consumerInfo.isShared()) {
                if (consumerInfo.isDurable()) {
                    if (this.sharedDurableSubs.containsKey(subscriptionName)) {
                        SubDetails subDetails = this.sharedDurableSubs.get(subscriptionName);
                        subDetails.removeSubscriber(consumerInfo);
                        int count = subDetails.activeSubscribers();
                        if (count < 1) {
                            this.sharedDurableSubs.remove(subscriptionName);
                        }
                    }
                } else if (this.sharedVolatileSubs.containsKey(subscriptionName)) {
                    SubDetails subDetails = this.sharedVolatileSubs.get(subscriptionName);
                    subDetails.removeSubscriber(consumerInfo);
                    int count = subDetails.activeSubscribers();
                    if (count < 1) {
                        this.sharedVolatileSubs.remove(subscriptionName);
                    }
                }
            } else if (consumerInfo.isDurable()) {
                this.exclusiveDurableSubs.remove(subscriptionName);
            }
        }
    }

    private static class SubDetails {
        private JmsDestination topic = null;
        private String selector = null;
        private Set<JmsConsumerInfo> subscribers = new HashSet<JmsConsumerInfo>();
        private int totalSubscriberCount;

        public SubDetails(JmsDestination topic, String selector, JmsConsumerInfo info) {
            if (topic == null) {
                throw new IllegalArgumentException("Topic destination must not be null");
            }
            this.topic = topic;
            this.selector = selector;
            this.addSubscriber(info);
        }

        public void addSubscriber(JmsConsumerInfo info) {
            if (info == null) {
                throw new IllegalArgumentException("Consumer info must not be null");
            }
            ++this.totalSubscriberCount;
            this.subscribers.add(info);
        }

        public void removeSubscriber(JmsConsumerInfo info) {
            this.subscribers.remove(info);
        }

        public int activeSubscribers() {
            return this.subscribers.size();
        }

        public int totalSubscriberCount() {
            return this.totalSubscriberCount;
        }

        public boolean matches(JmsDestination newTopic, String newSelector) {
            if (!this.topic.equals(newTopic)) {
                return false;
            }
            if (this.selector == null) {
                return newSelector == null;
            }
            return this.selector.equals(newSelector);
        }
    }
}

