/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.types.messaging.AmqpSequence;
import org.apache.qpid.protonj2.types.messaging.AmqpValue;
import org.apache.qpid.protonj2.types.messaging.ApplicationProperties;
import org.apache.qpid.protonj2.types.messaging.Data;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;
import org.apache.qpid.protonj2.types.messaging.Footer;
import org.apache.qpid.protonj2.types.messaging.Header;
import org.apache.qpid.protonj2.types.messaging.MessageAnnotations;
import org.apache.qpid.protonj2.types.messaging.Properties;
import org.apache.qpid.protonj2.types.messaging.Section;

public final class SectionEncoder {
    private final TypeEncoder<ApplicationProperties> apEncoder;
    private final TypeEncoder<MessageAnnotations> maEncoder;
    private final TypeEncoder<DeliveryAnnotations> daEncoder;
    private final TypeEncoder<Properties> propertiesEncoder;
    private final TypeEncoder<Header> headerEncoder;
    private final TypeEncoder<Footer> footerEncoder;
    private final TypeEncoder<Data> dataEncoder;
    private final TypeEncoder<AmqpSequence<?>> sequenceEncoder;
    private final TypeEncoder<AmqpValue<?>> valueEncoder;
    private final EncoderState encoderState;

    public SectionEncoder(Encoder encoder) {
        this.encoderState = encoder.newEncoderState();
        this.apEncoder = encoder.getTypeEncoder(ApplicationProperties.class);
        this.maEncoder = encoder.getTypeEncoder(MessageAnnotations.class);
        this.daEncoder = encoder.getTypeEncoder(DeliveryAnnotations.class);
        this.propertiesEncoder = encoder.getTypeEncoder(Properties.class);
        this.headerEncoder = encoder.getTypeEncoder(Header.class);
        this.footerEncoder = encoder.getTypeEncoder(Footer.class);
        this.dataEncoder = encoder.getTypeEncoder(Data.class);
        this.sequenceEncoder = encoder.getTypeEncoder(AmqpSequence.class);
        this.valueEncoder = encoder.getTypeEncoder(AmqpValue.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ProtonBuffer buffer, Section<?> section) {
        try {
            switch (section.getType()) {
                case AmqpSequence: {
                    this.sequenceEncoder.writeType(buffer, this.encoderState, (AmqpSequence)section);
                    return;
                }
                case AmqpValue: {
                    this.valueEncoder.writeType(buffer, this.encoderState, (AmqpValue)section);
                    return;
                }
                case ApplicationProperties: {
                    this.apEncoder.writeType(buffer, this.encoderState, (ApplicationProperties)section);
                    return;
                }
                case Data: {
                    this.dataEncoder.writeType(buffer, this.encoderState, (Data)section);
                    return;
                }
                case DeliveryAnnotations: {
                    this.daEncoder.writeType(buffer, this.encoderState, (DeliveryAnnotations)section);
                    return;
                }
                case Footer: {
                    this.footerEncoder.writeType(buffer, this.encoderState, (Footer)section);
                    return;
                }
                case Header: {
                    this.headerEncoder.writeType(buffer, this.encoderState, (Header)section);
                    return;
                }
                case MessageAnnotations: {
                    this.maEncoder.writeType(buffer, this.encoderState, (MessageAnnotations)section);
                    return;
                }
                case Properties: {
                    this.propertiesEncoder.writeType(buffer, this.encoderState, (Properties)section);
                    return;
                }
            }
            return;
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, ApplicationProperties properties) {
        try {
            this.apEncoder.writeType(buffer, this.encoderState, properties);
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, MessageAnnotations annotations) {
        try {
            this.maEncoder.writeType(buffer, this.encoderState, annotations);
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, DeliveryAnnotations annotations) {
        try {
            this.daEncoder.writeType(buffer, this.encoderState, annotations);
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, Properties properties) {
        try {
            this.propertiesEncoder.writeType(buffer, this.encoderState, properties);
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, Header header) {
        try {
            this.headerEncoder.writeType(buffer, this.encoderState, header);
        }
        finally {
            this.encoderState.reset();
        }
    }

    public void write(ProtonBuffer buffer, Footer footer) {
        try {
            this.footerEncoder.writeType(buffer, this.encoderState, footer);
        }
        finally {
            this.encoderState.reset();
        }
    }
}

