/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrders;
import com.microsoft.azure.management.appservice.AppServiceCertificates;
import com.microsoft.azure.management.appservice.AppServiceDomains;
import com.microsoft.azure.management.appservice.AppServicePlans;
import com.microsoft.azure.management.appservice.FunctionApps;
import com.microsoft.azure.management.appservice.WebApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateOrdersImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificatesImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceDomainsImpl;
import com.microsoft.azure.management.appservice.implementation.AppServicePlansImpl;
import com.microsoft.azure.management.appservice.implementation.FunctionAppsImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppsImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta
public final class AppServiceManager
extends Manager<AppServiceManager, WebSiteManagementClientImpl> {
    private GraphRbacManager rbacManager;
    private KeyVaultManager keyVaultManager;
    private StorageManager storageManager;
    private WebApps webApps;
    private AppServicePlans appServicePlans;
    private AppServiceCertificateOrders appServiceCertificateOrders;
    private AppServiceCertificates appServiceCertificates;
    private AppServiceDomains appServiceDomains;
    private FunctionApps functionApps;
    private RestClient restClient;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static AppServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new AppServiceManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), credentials.domain(), subscriptionId);
    }

    public static AppServiceManager authenticate(RestClient restClient, String tenantId, String subscriptionId) {
        return new AppServiceManager(restClient, tenantId, subscriptionId);
    }

    private AppServiceManager(RestClient restClient, String tenantId, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new WebSiteManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.keyVaultManager = KeyVaultManager.authenticate((RestClient)restClient, (String)tenantId, (String)subscriptionId);
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.rbacManager = GraphRbacManager.authenticate((RestClient)restClient, (String)tenantId);
        this.restClient = restClient;
    }

    GraphRbacManager rbacManager() {
        return this.rbacManager;
    }

    KeyVaultManager keyVaultManager() {
        return this.keyVaultManager;
    }

    StorageManager storageManager() {
        return this.storageManager;
    }

    RestClient restClient() {
        return this.restClient;
    }

    public WebApps webApps() {
        if (this.webApps == null) {
            this.webApps = new WebAppsImpl(this);
        }
        return this.webApps;
    }

    public AppServicePlans appServicePlans() {
        if (this.appServicePlans == null) {
            this.appServicePlans = new AppServicePlansImpl(this);
        }
        return this.appServicePlans;
    }

    public AppServiceCertificateOrders certificateOrders() {
        if (this.appServiceCertificateOrders == null) {
            this.appServiceCertificateOrders = new AppServiceCertificateOrdersImpl(this);
        }
        return this.appServiceCertificateOrders;
    }

    public AppServiceCertificates certificates() {
        if (this.appServiceCertificates == null) {
            this.appServiceCertificates = new AppServiceCertificatesImpl(this);
        }
        return this.appServiceCertificates;
    }

    public AppServiceDomains domains() {
        if (this.appServiceDomains == null) {
            this.appServiceDomains = new AppServiceDomainsImpl(this);
        }
        return this.appServiceDomains;
    }

    public FunctionApps functionApps() {
        if (this.functionApps == null) {
            this.functionApps = new FunctionAppsImpl(this);
        }
        return this.functionApps;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public AppServiceManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return AppServiceManager.authenticate(this.buildRestClient(credentials), credentials.domain(), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public AppServiceManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

