/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.sizing;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class PerfMemTimeTracker {
    public static final String STR_INTENT = "  ";
    public static final String STR_FIELD_SEP = "|";
    private final String tag;
    private final long startTime;
    private long endTime;
    private long gcTime;
    private final long startMemory;
    private long endMemory;
    private List<PerfMemTimeTracker> children = null;

    public PerfMemTimeTracker(String tag) {
        this.tag = tag;
        this.startTime = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        this.gcTime = System.currentTimeMillis() - this.startTime;
        this.startMemory = rt.totalMemory() - rt.freeMemory();
    }

    public void stop() {
        long gcStartTime = System.currentTimeMillis();
        Runtime rt = Runtime.getRuntime();
        rt.runFinalization();
        rt.gc();
        this.endTime = System.currentTimeMillis();
        this.gcTime += this.endTime - gcStartTime;
        this.endMemory = rt.totalMemory() - rt.freeMemory();
    }

    public void addChild(PerfMemTimeTracker tracker) {
        if (this.children == null) {
            this.children = new ArrayList<PerfMemTimeTracker>();
        }
        this.children.add(tracker);
    }

    public String getTag() {
        return this.tag;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getGcTime() {
        return this.gcTime;
    }

    public long getStartMemory() {
        return this.startMemory;
    }

    public long getEndMemory() {
        return this.endMemory;
    }

    public List<PerfMemTimeTracker> getChildren() {
        return this.children;
    }

    public long getTimeTaken() {
        return this.endTime - this.startTime - this.getTotalGcTime();
    }

    public long getTotalGcTime() {
        long ret = this.gcTime;
        if (this.children != null) {
            for (PerfMemTimeTracker child : this.children) {
                ret += child.getTotalGcTime();
            }
        }
        return ret;
    }

    public long getMemoryDelta() {
        return this.endMemory - this.startMemory;
    }

    public void print(PrintStream out, boolean printHeader) {
        if (printHeader) {
            out.println("Task|Time (ms)|Memory (bytes)");
        }
        this.print("", out);
    }

    public String toString() {
        return this.tag + ", Memory: (start: " + this.startMemory + ", end: " + this.endMemory + ", delta: " + this.getMemoryDelta() + ") bytes, TimeTaken: " + this.getTimeTaken() + "ms";
    }

    private void print(String intentString, PrintStream out) {
        out.println(intentString + this.tag + STR_FIELD_SEP + this.getTimeTaken() + STR_FIELD_SEP + this.getMemoryDelta());
        if (this.children != null) {
            for (PerfMemTimeTracker child : this.children) {
                child.print(intentString + STR_INTENT, out);
            }
        }
    }
}

