/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.knox.client;

import java.util.List;
import java.util.Map;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.knox.client.KnoxClient;
import org.apache.ranger.services.knox.client.KnoxConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxResourceMgr {
    private static final Logger LOG = LoggerFactory.getLogger(KnoxResourceMgr.class);
    private static final String TOPOLOGY = "topology";
    private static final String SERVICE = "service";

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> KnoxResourceMgr.testConnection ServiceName: " + serviceName + "Configs" + configs);
        }
        try {
            ret = KnoxClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== KnoxResourceMgr.connectionTest Error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== KnoxResourceMgr.HdfsResourceMgr Result : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getKnoxResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        KnoxClient knoxClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        List<String> resultList = null;
        List knoxTopologyList = null;
        List knoxServiceList = null;
        String knoxTopologyName = null;
        String knoxServiceName = null;
        if (userInput != null && resource != null) {
            if (resourceMap != null && !resourceMap.isEmpty()) {
                knoxTopologyList = (List)resourceMap.get(TOPOLOGY);
                knoxServiceList = (List)resourceMap.get(SERVICE);
            }
            switch (resource.trim().toLowerCase()) {
                case "topology": {
                    knoxTopologyName = userInput;
                    break;
                }
                case "service": {
                    knoxServiceName = userInput;
                    break;
                }
            }
        }
        String knoxUrl = configs.get("knox.url");
        String knoxAdminUser = configs.get("username");
        String knoxAdminPassword = configs.get("password");
        if (knoxUrl == null || knoxUrl.isEmpty()) {
            LOG.error("Unable to get knox resources: knoxUrl is empty");
            return resultList;
        }
        if (knoxAdminUser == null || knoxAdminUser.isEmpty()) {
            LOG.error("Unable to get knox resources: knoxAdminUser is empty");
            return resultList;
        }
        if (knoxAdminPassword == null || knoxAdminPassword.isEmpty()) {
            LOG.error("Unable to get knox resources: knoxAdminPassword is empty");
            return resultList;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== KnoxResourceMgr.getKnoxResources()  knoxUrl: " + knoxUrl + " knoxAdminUser: " + knoxAdminUser + " topologyName: " + knoxTopologyName + " KnoxServiceName: " + knoxServiceName);
        }
        if ((knoxClient = new KnoxConnectionMgr().getKnoxClient(knoxUrl, knoxAdminUser, knoxAdminPassword)) != null) {
            KnoxClient knoxClient2 = knoxClient;
            synchronized (knoxClient2) {
                resultList = KnoxClient.getKnoxResources(knoxClient, knoxTopologyName, knoxServiceName, knoxTopologyList, knoxServiceList);
            }
        }
        return resultList;
    }
}

