/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collection;
import java.util.Collections;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.DataStreamException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;

public class RaftClientReply
extends RaftClientMessage {
    private final boolean success;
    private final RaftException exception;
    private final Message message;
    private final long logIndex;
    private final Collection<RaftProtos.CommitInfoProto> commitInfos;

    public static Builder newBuilder() {
        return new Builder();
    }

    RaftClientReply(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, boolean success, Message message, RaftException exception, long logIndex, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        super(clientId, serverId, groupId, callId);
        this.success = success;
        this.message = message;
        this.exception = exception;
        this.logIndex = logIndex;
        Collection<RaftProtos.CommitInfoProto> collection = this.commitInfos = commitInfos != null ? commitInfos : Collections.emptyList();
        if (exception != null) {
            Preconditions.assertTrue(!success, () -> "Inconsistent parameters: success && exception != null: " + this);
            Preconditions.assertTrue(ReflectionUtils.isInstance(exception, AlreadyClosedException.class, NotLeaderException.class, NotReplicatedException.class, LeaderNotReadyException.class, StateMachineException.class, DataStreamException.class, LeaderSteppingDownException.class, TransferLeadershipException.class, ReadException.class, ReadIndexException.class), () -> "Unexpected exception class: " + this);
        }
    }

    public Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        return this.commitInfos;
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + (this.isSuccess() ? "SUCCESS" : "FAILED " + this.exception) + ", logIndex=" + this.getLogIndex() + ", commits" + ProtoUtils.toString(this.commitInfos);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Message getMessage() {
        return this.message;
    }

    public AlreadyClosedException getAlreadyClosedException() {
        return JavaUtils.cast(this.exception, AlreadyClosedException.class);
    }

    public NotLeaderException getNotLeaderException() {
        return JavaUtils.cast(this.exception, NotLeaderException.class);
    }

    public NotReplicatedException getNotReplicatedException() {
        return JavaUtils.cast(this.exception, NotReplicatedException.class);
    }

    public StateMachineException getStateMachineException() {
        return JavaUtils.cast(this.exception, StateMachineException.class);
    }

    public DataStreamException getDataStreamException() {
        return JavaUtils.cast(this.exception, DataStreamException.class);
    }

    public LeaderNotReadyException getLeaderNotReadyException() {
        return JavaUtils.cast(this.exception, LeaderNotReadyException.class);
    }

    public LeaderSteppingDownException getLeaderSteppingDownException() {
        return JavaUtils.cast(this.exception, LeaderSteppingDownException.class);
    }

    public TransferLeadershipException getTransferLeadershipException() {
        return JavaUtils.cast(this.exception, TransferLeadershipException.class);
    }

    public ReadException getReadException() {
        return JavaUtils.cast(this.exception, ReadException.class);
    }

    public ReadIndexException getReadIndexException() {
        return JavaUtils.cast(this.exception, ReadIndexException.class);
    }

    public RaftException getException() {
        return this.exception;
    }

    public static class Builder {
        private ClientId clientId;
        private RaftPeerId serverId;
        private RaftGroupId groupId;
        private long callId;
        private boolean success;
        private Message message;
        private RaftException exception;
        private long logIndex;
        private Collection<RaftProtos.CommitInfoProto> commitInfos;

        public RaftClientReply build() {
            return new RaftClientReply(this.clientId, this.serverId, this.groupId, this.callId, this.success, this.message, this.exception, this.logIndex, this.commitInfos);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setServerId(RaftPeerId serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder setGroupId(RaftGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setCallId(long callId) {
            this.callId = callId;
            return this;
        }

        public Builder setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public Builder setSuccess() {
            return this.setSuccess(true);
        }

        public Builder setException(RaftException exception) {
            this.exception = exception;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setLogIndex(long logIndex) {
            this.logIndex = logIndex;
            return this;
        }

        public Builder setCommitInfos(Collection<RaftProtos.CommitInfoProto> commitInfos) {
            this.commitInfos = commitInfos;
            return this;
        }

        public Builder setServerId(RaftGroupMemberId serverId) {
            return this.setServerId(serverId.getPeerId()).setGroupId(serverId.getGroupId());
        }

        public Builder setClientInvocationId(ClientInvocationId invocationId) {
            return this.setClientId(invocationId.getClientId()).setCallId(invocationId.getLongId());
        }

        public Builder setRequest(RaftClientRequest request) {
            return this.setClientId(request.getClientId()).setServerId(request.getServerId()).setGroupId(request.getRaftGroupId()).setCallId(request.getCallId());
        }
    }
}

