/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final Resource TELEMETRY_SDK;
    private static final Resource MANDATORY;
    private static final Resource DEFAULT;

    public static Resource getDefault() {
        return DEFAULT;
    }

    public static Resource empty() {
        return EMPTY;
    }

    public static Resource create(Attributes attributes) {
        return Resource.create(attributes, null);
    }

    public static Resource create(Attributes attributes, @Nullable String schemaUrl) {
        Resource.checkAttributes(Objects.requireNonNull(attributes, "attributes"));
        return new AutoValue_Resource(schemaUrl, attributes);
    }

    @Nullable
    public abstract String getSchemaUrl();

    public abstract Attributes getAttributes();

    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        return (T)this.getAttributes().get(key);
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.putAll(this.getAttributes());
        attrBuilder.putAll(other.getAttributes());
        if (other.getSchemaUrl() == null) {
            return Resource.create(attrBuilder.build(), this.getSchemaUrl());
        }
        if (this.getSchemaUrl() == null) {
            return Resource.create(attrBuilder.build(), other.getSchemaUrl());
        }
        if (!other.getSchemaUrl().equals(this.getSchemaUrl())) {
            logger.info("Attempting to merge Resources with different schemaUrls. The resulting Resource will have no schemaUrl assigned. Schema 1: " + this.getSchemaUrl() + " Schema 2: " + other.getSchemaUrl());
            return Resource.create(attrBuilder.build(), null);
        }
        return Resource.create(attrBuilder.build(), this.getSchemaUrl());
    }

    private static void checkAttributes(Attributes attributes) {
        attributes.forEach((key, value) -> {
            Utils.checkArgument((boolean)Resource.isValidAndNotEmpty(key), (String)"Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Objects.requireNonNull(value, "Attribute value should be a ASCII string with a length not exceed 255 characters.");
        });
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString((String)name);
    }

    private static boolean isValidAndNotEmpty(AttributeKey<?> name) {
        return !name.getKey().isEmpty() && Resource.isValid(name.getKey());
    }

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        ResourceBuilder resourceBuilder = Resource.builder().putAll(this);
        if (this.getSchemaUrl() != null) {
            resourceBuilder.setSchemaUrl(this.getSchemaUrl());
        }
        return resourceBuilder;
    }

    Resource() {
    }

    static {
        MANDATORY = Resource.create(Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)"unknown_service:java"));
        TELEMETRY_SDK = Resource.create(Attributes.builder().put(ResourceAttributes.TELEMETRY_SDK_NAME, (Object)"opentelemetry").put(ResourceAttributes.TELEMETRY_SDK_LANGUAGE, (Object)"java").put(ResourceAttributes.TELEMETRY_SDK_VERSION, (Object)"1.29.0").build());
        DEFAULT = MANDATORY.merge(TELEMETRY_SDK);
    }
}

