/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;
import java.text.DecimalFormat;

final class ObjectWriterImplDouble
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplDouble INSTANCE = new ObjectWriterImplDouble(null);
    private final DecimalFormat format;

    public ObjectWriterImplDouble(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.writeDouble((Double)object);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        String format;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        DecimalFormat decimalFormat = this.format;
        if (decimalFormat == null && (format = jsonWriter.getContext().getDateFormat()) != null && format.indexOf("#") != -1) {
            decimalFormat = new DecimalFormat(format);
        }
        if (decimalFormat != null) {
            String str = decimalFormat.format(object);
            jsonWriter.writeRaw(str);
            return;
        }
        jsonWriter.writeDouble((Double)object);
        long features2 = jsonWriter.getFeatures(features);
        if ((features2 & JSONWriter.Feature.WriteClassName.mask) != 0L && (features2 & JSONWriter.Feature.WriteNonStringKeyAsString.mask) == 0L && (features2 & JSONWriter.Feature.NotWriteNumberClassName.mask) == 0L && fieldType != Double.class && fieldType != Double.TYPE) {
            jsonWriter.writeRaw('D');
        }
    }
}

