/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.internal.ComponentRegistry;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogEmitter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogEmitterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogEmitterSharedState;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogLimits;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.LogProcessor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.SdkLogEmitter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.SdkLogEmitterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class SdkLogEmitterProvider
implements Closeable {
    static final String DEFAULT_EMITTER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLogEmitterProvider.class.getName());
    private final LogEmitterSharedState sharedState;
    private final ComponentRegistry<SdkLogEmitter> logEmitterComponentRegistry;

    public static SdkLogEmitterProviderBuilder builder() {
        return new SdkLogEmitterProviderBuilder();
    }

    SdkLogEmitterProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogProcessor> processors, Clock clock) {
        this.sharedState = new LogEmitterSharedState(resource, logLimitsSupplier, processors, clock);
        this.logEmitterComponentRegistry = new ComponentRegistry<SdkLogEmitter>(instrumentationScopeInfo -> new SdkLogEmitter(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
    }

    public LogEmitter get(String instrumentationScopeName) {
        return this.logEmitterBuilder(instrumentationScopeName).build();
    }

    public LogEmitterBuilder logEmitterBuilder(String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("LogEmitter requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_EMITTER_NAME;
        }
        return new SdkLogEmitterBuilder(this.logEmitterComponentRegistry, instrumentationScopeName);
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

