/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import java.util.PriorityQueue;
import org.locationtech.jts.algorithm.construct.IndexedDistanceToPoint;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;

public class LargestEmptyCircle {
    private Geometry obstacles;
    private Geometry boundary;
    private double tolerance;
    private GeometryFactory factory;
    private IndexedDistanceToPoint obstacleDistance;
    private IndexedPointInAreaLocator boundaryPtLocater;
    private IndexedFacetDistance boundaryDistance;
    private Envelope gridEnv;
    private Cell farthestCell;
    private Cell centerCell = null;
    private Coordinate centerPt;
    private Point centerPoint = null;
    private Coordinate radiusPt;
    private Point radiusPoint = null;
    private Geometry bounds;

    public static Point getCenter(Geometry obstacles, double tolerance) {
        return LargestEmptyCircle.getCenter(obstacles, null, tolerance);
    }

    public static Point getCenter(Geometry obstacles, Geometry boundary, double tolerance) {
        LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, boundary, tolerance);
        return lec.getCenter();
    }

    public static LineString getRadiusLine(Geometry obstacles, double tolerance) {
        return LargestEmptyCircle.getRadiusLine(obstacles, null, tolerance);
    }

    public static LineString getRadiusLine(Geometry obstacles, Geometry boundary, double tolerance) {
        LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, boundary, tolerance);
        return lec.getRadiusLine();
    }

    public LargestEmptyCircle(Geometry obstacles, Geometry boundary, double tolerance) {
        if (obstacles == null || obstacles.isEmpty()) {
            throw new IllegalArgumentException("Obstacles geometry is empty or null");
        }
        if (boundary != null && !(boundary instanceof Polygonal)) {
            throw new IllegalArgumentException("Boundary must be polygonal");
        }
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException("Accuracy tolerance is non-positive: " + tolerance);
        }
        this.obstacles = obstacles;
        this.boundary = boundary;
        this.factory = obstacles.getFactory();
        this.tolerance = tolerance;
        this.obstacleDistance = new IndexedDistanceToPoint(obstacles);
    }

    public Point getCenter() {
        this.compute();
        return this.centerPoint;
    }

    public Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint;
    }

    public LineString getRadiusLine() {
        this.compute();
        LineString radiusLine = this.factory.createLineString(new Coordinate[]{this.centerPt.copy(), this.radiusPt.copy()});
        return radiusLine;
    }

    private double distanceToConstraints(Point p) {
        boolean isOutide;
        boolean bl = isOutide = 2 == this.boundaryPtLocater.locate(p.getCoordinate());
        if (isOutide) {
            double boundaryDist = this.boundaryDistance.distance(p);
            return -boundaryDist;
        }
        double dist = this.obstacleDistance.distance(p);
        return dist;
    }

    private double distanceToConstraints(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory.createPoint(coord);
        return this.distanceToConstraints(pt);
    }

    private void initBoundary() {
        this.bounds = this.boundary;
        if (this.bounds == null || this.bounds.isEmpty()) {
            this.bounds = this.obstacles.convexHull();
        }
        this.gridEnv = this.bounds.getEnvelopeInternal();
        if (this.bounds.getDimension() >= 2) {
            this.boundaryPtLocater = new IndexedPointInAreaLocator(this.bounds);
            this.boundaryDistance = new IndexedFacetDistance(this.bounds);
        }
    }

    private void compute() {
        this.initBoundary();
        if (this.centerCell != null) {
            return;
        }
        if (this.boundaryPtLocater == null) {
            Coordinate pt = this.obstacles.getCoordinate();
            this.centerPt = pt.copy();
            this.centerPoint = this.factory.createPoint(pt);
            this.radiusPt = pt.copy();
            this.radiusPoint = this.factory.createPoint(pt);
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>();
        this.createInitialGrid(this.gridEnv, cellQueue);
        this.farthestCell = this.createCentroidCell(this.obstacles);
        long maxIter = MaximumInscribedCircle.computeMaximumIterations(this.bounds, this.tolerance);
        long iter = 0L;
        while (!cellQueue.isEmpty() && iter < maxIter) {
            ++iter;
            Cell cell = (Cell)cellQueue.remove();
            if (cell.getDistance() > this.farthestCell.getDistance()) {
                this.farthestCell = cell;
            }
            if (!this.mayContainCircleCenter(cell)) continue;
            double h2 = cell.getHSide() / 2.0;
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2));
        }
        this.centerCell = this.farthestCell;
        this.centerPt = new Coordinate(this.centerCell.getX(), this.centerCell.getY());
        this.centerPoint = this.factory.createPoint(this.centerPt);
        Coordinate[] nearestPts = this.obstacleDistance.nearestPoints(this.centerPoint);
        this.radiusPt = nearestPts[0].copy();
        this.radiusPoint = this.factory.createPoint(this.radiusPt);
    }

    private boolean mayContainCircleCenter(Cell cell) {
        if (cell.isFullyOutside()) {
            return false;
        }
        if (cell.isOutside()) {
            boolean isOverlapSignificant = cell.getMaxDistance() > this.tolerance;
            return isOverlapSignificant;
        }
        double potentialIncrease = cell.getMaxDistance() - this.farthestCell.getDistance();
        return potentialIncrease > this.tolerance;
    }

    private void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double cellSize = Math.max(env.getWidth(), env.getHeight());
        double hSide = cellSize / 2.0;
        if (cellSize == 0.0) {
            return;
        }
        Coordinate centre = env.centre();
        cellQueue.add(this.createCell(centre.x, centre.y, hSide));
    }

    private Cell createCell(double x, double y, double h2) {
        return new Cell(x, y, h2, this.distanceToConstraints(x, y));
    }

    private Cell createCentroidCell(Geometry geom) {
        Point p = geom.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, this.distanceToConstraints(p));
    }

    private static class Cell
    implements Comparable<Cell> {
        private static final double SQRT2 = 1.4142135623730951;
        private double x;
        private double y;
        private double hSide;
        private double distance;
        private double maxDist;

        Cell(double x, double y, double hSide, double distanceToConstraints) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distanceToConstraints;
            this.maxDist = this.distance + hSide * 1.4142135623730951;
        }

        public boolean isFullyOutside() {
            return this.getMaxDistance() < 0.0;
        }

        public boolean isOutside() {
            return this.distance < 0.0;
        }

        public double getMaxDistance() {
            return this.maxDist;
        }

        public double getDistance() {
            return this.distance;
        }

        public double getHSide() {
            return this.hSide;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        @Override
        public int compareTo(Cell o) {
            return -Double.compare(this.maxDist, o.maxDist);
        }
    }
}

