/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import java.time.Duration;
import org.apache.servicecomb.governance.policy.AbstractPolicy;

public class BulkheadPolicy
extends AbstractPolicy {
    public static final int DEFAULT_MAX_CONCURRENT_CALLS = 1000;
    public static final Duration DEFAULT_MAX_WAIT_DURATION = Duration.ofMillis(0L);
    private int maxConcurrentCalls = 1000;
    private String maxWaitDuration = DEFAULT_MAX_WAIT_DURATION.toString();

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public void setMaxConcurrentCalls(int maxConcurrentCalls) {
        this.maxConcurrentCalls = maxConcurrentCalls;
    }

    public String getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public void setMaxWaitDuration(String maxWaitDuration) {
        this.maxWaitDuration = this.stringOfDuration(maxWaitDuration, DEFAULT_MAX_WAIT_DURATION);
    }

    @Override
    public boolean isValid() {
        if (this.maxConcurrentCalls < 0) {
            return false;
        }
        if (Duration.parse(this.maxWaitDuration).toMillis() < 0L) {
            return false;
        }
        return super.isValid();
    }

    public String toString() {
        return "BulkheadPolicy{maxConcurrentCalls=" + this.maxConcurrentCalls + ", maxWaitDuration=" + this.maxWaitDuration + "}";
    }
}

