/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.servlet.http.Part;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.ParameterTypeProcessor;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class PartParameterTypeProcessor
implements ParameterTypeProcessor {
    @Override
    public JavaType getProcessType() {
        return TypeFactory.defaultInstance().constructType(Part.class);
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ParameterGenerator parameterGenerator) {
        if (!parameterGenerator.getParameterGeneratorContext().getSupportedConsumes().contains("multipart/form-data")) {
            throw new IllegalArgumentException("Part type must declare consumes multipart/form-data");
        }
        if (parameterGenerator.getHttpParameterType() != HttpParameterType.FORM) {
            throw new IllegalArgumentException(this.getProcessType().getRawClass().getSimpleName() + " type must declare as form parameter.");
        }
        if (StringUtils.isEmpty((CharSequence)parameterGenerator.getParameterGeneratorContext().getParameterName())) {
            throw new IllegalArgumentException("Name is required for parameter " + this.getProcessType().getRawClass().getSimpleName());
        }
        parameterGenerator.getParameterGeneratorContext().updateConsumes(List.of("multipart/form-data"));
        this.formParameterSchema(parameterGenerator);
    }

    protected void formParameterSchema(ParameterGenerator parameterGenerator) {
        parameterGenerator.getParameterGeneratorContext().setSchema((Schema<?>)new FileSchema());
    }
}

