/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.checker.dml;

import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sharding.exception.syntax.DMLMultipleDataNodesWithLimitException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedUpdatingShardingValueException;
import org.apache.shardingsphere.sharding.route.engine.checker.ShardingRouteContextChecker;
import org.apache.shardingsphere.sharding.route.engine.checker.util.ShardingRouteContextCheckUtils;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class ShardingUpdateRouteContextChecker
implements ShardingRouteContextChecker {
    @Override
    public void check(ShardingRule shardingRule, QueryContext queryContext, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        UpdateStatementContext updateStatementContext = (UpdateStatementContext)sqlStatementContext;
        String tableName = (String)updateStatementContext.getTablesContext().getTableNames().iterator().next();
        UpdateStatement updateStatement = updateStatementContext.getSqlStatement();
        Optional<ShardingConditions> shardingConditions = ShardingRouteContextCheckUtils.createShardingConditions(sqlStatementContext, shardingRule, updateStatement.getSetAssignment().getAssignments(), queryContext.getParameters());
        Optional<RouteContext> setAssignmentRouteContext = shardingConditions.map(optional -> new ShardingStandardRouteEngine(tableName, (ShardingConditions)optional, sqlStatementContext, queryContext.getHintValueContext(), props).route(shardingRule));
        if (setAssignmentRouteContext.isPresent() && !ShardingRouteContextCheckUtils.isSameRouteContext(routeContext, setAssignmentRouteContext.get())) {
            throw new UnsupportedUpdatingShardingValueException(tableName);
        }
        ShardingSpherePreconditions.checkState((!updateStatement.getLimit().isPresent() || routeContext.getRouteUnits().size() <= 1 ? 1 : 0) != 0, () -> new DMLMultipleDataNodesWithLimitException("UPDATE"));
    }
}

