/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum;

import java.util.List;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.rownum.RowNumberValueSegment;

public final class ExpressionRowNumberValueSegment
extends RowNumberValueSegment {
    private final ExpressionSegment expressionSegment;

    public ExpressionRowNumberValueSegment(int startIndex, int stopIndex, ExpressionSegment expressionSegment, boolean boundOpened) {
        super(startIndex, stopIndex, boundOpened);
        this.expressionSegment = expressionSegment;
    }

    public Long getValue(List<Object> params) {
        return this.getValueFromExpression(this.expressionSegment, params);
    }

    private Long getValueFromExpression(ExpressionSegment expressionSegment, List<Object> params) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            return null == params || params.isEmpty() ? 0L : Long.parseLong(params.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex()).toString());
        }
        if (expressionSegment instanceof BinaryOperationExpression) {
            return this.getValueFromBinaryOperationExpression((BinaryOperationExpression)expressionSegment, params);
        }
        if (expressionSegment instanceof LiteralExpressionSegment) {
            return Long.parseLong(expressionSegment.getText());
        }
        throw new UnsupportedOperationException(String.format("Unsupported expression: %s in page expression", expressionSegment.getClass().getName()));
    }

    private Long getValueFromBinaryOperationExpression(BinaryOperationExpression binaryOperationExpression, List<Object> params) {
        String operator = binaryOperationExpression.getOperator();
        Long leftValue = this.getValueFromExpression(binaryOperationExpression.getLeft(), params);
        Long rightValue = this.getValueFromExpression(binaryOperationExpression.getRight(), params);
        switch (operator) {
            case "+": {
                return leftValue + rightValue;
            }
            case "-": {
                return leftValue - rightValue;
            }
            case "*": {
                return leftValue * rightValue;
            }
            case "/": {
                return leftValue / rightValue;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported operator: %s in page expression", operator));
    }
}

