/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.ConstraintAvailable;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public final class CreateTableStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable,
ConstraintAvailable {
    private final TablesContext tablesContext;

    public CreateTableStatementContext(CreateTableStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.getTables(sqlStatement));
    }

    private Collection<SimpleTableSegment> getTables(CreateTableStatement sqlStatement) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(sqlStatement.getTable());
        for (ColumnDefinitionSegment each : sqlStatement.getColumnDefinitions()) {
            result.addAll(each.getReferencedTables());
        }
        for (ColumnDefinitionSegment each : sqlStatement.getConstraintDefinitions()) {
            if (!each.getReferencedTable().isPresent()) continue;
            result.add((SimpleTableSegment)each.getReferencedTable().get());
        }
        return result;
    }

    public CreateTableStatement getSqlStatement() {
        return (CreateTableStatement)super.getSqlStatement();
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            each.getIndexName().ifPresent(result::add);
        }
        return result;
    }

    @Override
    public Collection<ConstraintSegment> getConstraints() {
        LinkedList<ConstraintSegment> result = new LinkedList<ConstraintSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            each.getConstraintName().ifPresent(result::add);
        }
        return result;
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ConstraintDefinitionSegment each : this.getSqlStatement().getConstraintDefinitions()) {
            result.addAll(each.getIndexColumns());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

