/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptRuleStatementConverter;
import org.apache.shardingsphere.encrypt.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.encrypt.distsql.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

@DistSQLExecutorCurrentRuleRequired(value=EncryptRule.class)
public final class AlterEncryptRuleExecutor
implements DatabaseRuleAlterExecutor<AlterEncryptRuleStatement, EncryptRule, EncryptRuleConfiguration> {
    private ShardingSphereDatabase database;
    private EncryptRule rule;

    public void checkBeforeUpdate(AlterEncryptRuleStatement sqlStatement) {
        this.checkToBeAlteredRules(sqlStatement);
        this.checkColumnNames(sqlStatement);
        this.checkToBeAlteredEncryptors(sqlStatement);
    }

    private void checkToBeAlteredRules(AlterEncryptRuleStatement sqlStatement) {
        Collection notExistEncryptTableNames = this.getToBeAlteredEncryptTableNames(sqlStatement).stream().filter(each -> !this.rule.getAllTableNames().contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistEncryptTableNames, () -> new MissingRequiredRuleException("Encrypt", this.database.getName(), notExistEncryptTableNames));
    }

    private Collection<String> getToBeAlteredEncryptTableNames(AlterEncryptRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(EncryptRuleSegment::getTableName).collect(Collectors.toList());
    }

    private void checkColumnNames(AlterEncryptRuleStatement sqlStatement) {
        for (EncryptRuleSegment each : sqlStatement.getRules()) {
            ShardingSpherePreconditions.checkState((boolean)this.isColumnNameNotConflicts(each), () -> new InvalidRuleConfigurationException("encrypt", "assisted query column or like query column conflicts with logic column"));
        }
    }

    private boolean isColumnNameNotConflicts(EncryptRuleSegment rule) {
        return rule.getColumns().stream().noneMatch(each -> null != each.getLikeQuery() && each.getName().equals(each.getLikeQuery().getName()) || null != each.getAssistedQuery() && each.getName().equals(each.getAssistedQuery().getName()));
    }

    private void checkToBeAlteredEncryptors(AlterEncryptRuleStatement sqlStatement) {
        LinkedHashSet encryptors = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> each.getColumns().forEach(column -> {
            encryptors.add(column.getCipher().getEncryptor());
            if (null != column.getAssistedQuery()) {
                encryptors.add(column.getAssistedQuery().getEncryptor());
            }
            if (null != column.getLikeQuery()) {
                encryptors.add(column.getLikeQuery().getEncryptor());
            }
        }));
        encryptors.stream().filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    public EncryptRuleConfiguration buildToBeAlteredRuleConfiguration(AlterEncryptRuleStatement sqlStatement) {
        return EncryptRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public EncryptRuleConfiguration buildToBeDroppedRuleConfiguration(EncryptRuleConfiguration toBeAlteredRuleConfig) {
        Collection<String> unusedEncryptor = UnusedAlgorithmFinder.findUnusedEncryptor(this.rule.getConfiguration());
        HashMap toBeDroppedEncryptors = new HashMap(unusedEncryptor.size(), 1.0f);
        unusedEncryptor.forEach(each -> toBeDroppedEncryptors.put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getEncryptors().get(each)));
        return new EncryptRuleConfiguration(Collections.emptyList(), toBeDroppedEncryptors);
    }

    public Class<EncryptRule> getRuleClass() {
        return EncryptRule.class;
    }

    public Class<AlterEncryptRuleStatement> getType() {
        return AlterEncryptRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(EncryptRule rule) {
        this.rule = rule;
    }
}

