/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.mode.metadata.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

@ThreadSafe
public final class MetaDataContexts {
    private final AtomicReference<ShardingSphereMetaData> metaData = new AtomicReference();
    private final AtomicReference<ShardingSphereStatistics> statistics = new AtomicReference();

    public MetaDataContexts(ShardingSphereMetaData metaData, ShardingSphereStatistics statistics) {
        this.metaData.set(metaData);
        this.statistics.set(statistics);
    }

    public ShardingSphereMetaData getMetaData() {
        return this.metaData.get();
    }

    public ShardingSphereStatistics getStatistics() {
        return this.statistics.get();
    }

    public void update(MetaDataContexts newMetaDataContexts) {
        this.metaData.set(newMetaDataContexts.getMetaData());
        this.statistics.set(newMetaDataContexts.getStatistics());
    }

    public void update(ShardingSphereMetaData metaData, MetaDataPersistService metaDataPersistService) {
        this.metaData.set(metaData);
        this.statistics.set(ShardingSphereStatisticsFactory.create(metaDataPersistService, metaData));
    }
}

